/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.compat.hbm;

import com.hbm.explosion.ExplosionNT;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.threading.ThreadedPacket;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={5.class, 4.class, 3.class, 2.class, 1.class})
public class MukeContainer {
    public static MukeContainer PARAMS_SAFE = new MukeContainer(){
        {
            this.safe = true;
            this.killRadius = 45.0f;
            this.radiationLevel = 2.0f;
        }
    };
    public static MukeContainer PARAMS_TOTS = new MukeContainer(){
        {
            this.blastRadius = 10.0f;
            this.killRadius = 30.0f;
            this.particle = "tinytot";
            this.shrapnelCount = 0;
            this.resolution = 32;
            this.radiationLevel = 1.0f;
        }
    };
    public static MukeContainer PARAMS_LOW = new MukeContainer(){
        {
            this.blastRadius = 15.0f;
            this.killRadius = 45.0f;
            this.radiationLevel = 2.0f;
        }
    };
    public static MukeContainer PARAMS_MEDIUM = new MukeContainer(){
        {
            this.blastRadius = 20.0f;
            this.killRadius = 55.0f;
            this.radiationLevel = 3.0f;
        }
    };
    public static MukeContainer PARAMS_HIGH = new MukeContainer(){
        {
            this.miniNuke = false;
            this.blastRadius = 35.0f;
            this.shrapnelCount = 0;
        }
    };
    public boolean miniNuke = true;
    public boolean safe = false;
    public float blastRadius;
    public float killRadius;
    public float radiationLevel = 1.0f;
    public String particle = "muke";
    public int shrapnelCount = 25;
    public int resolution = 64;
    public List<String> attributes = Arrays.asList("FIRE", "NOPARTICLE", "NOSOUND", "NODROP", "NOHURT");
    private List<Object> runtimeAttribs;

    @Optional.Method(modid="hbm")
    public void loadRuntimeInstances() {
        this.runtimeAttribs = this.attributes.stream().map(ExplosionNT.ExAttrib::valueOf).collect(Collectors.toList());
    }

    @Optional.Method(modid="hbm")
    public void explode(World world, double posX, double posY, double posZ, boolean effectOnly) {
        if (effectOnly) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            PacketThreading.createAllAroundThreadedPacket((ThreadedPacket)new AuxParticlePacketNT(data, posX, posY + 0.5, posZ), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), posX, posY, posZ, 250.0));
            return;
        }
        Object type = this.getCustomMukeConfig();
        ExplosionNukeSmall.explode((World)world, (double)posX, (double)posY, (double)posZ, (ExplosionNukeSmall.MukeParams)((ExplosionNukeSmall.MukeParams)type));
    }

    @Optional.Method(modid="hbm")
    public Object getCustomMukeConfig() {
        ExplosionNukeSmall.MukeParams muke = new ExplosionNukeSmall.MukeParams();
        muke.miniNuke = this.miniNuke;
        muke.safe = this.safe;
        muke.blastRadius = this.blastRadius;
        muke.killRadius = this.killRadius;
        muke.radiationLevel = this.radiationLevel;
        muke.particle = this.particle;
        muke.shrapnelCount = this.shrapnelCount;
        muke.resolution = this.resolution;
        if (this.runtimeAttribs != null && !this.runtimeAttribs.isEmpty()) {
            muke.explosionAttribs = this.runtimeAttribs.toArray(new ExplosionNT.ExAttrib[0]);
        }
        return muke;
    }

    @Generated
    public MukeContainer() {
    }

    @Generated
    public List<Object> getRuntimeAttribs() {
        return this.runtimeAttribs;
    }
}

