/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.compat;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModCompatManager {
    public static final Map<String, Boolean> LOADED_CACHE = new ConcurrentHashMap<String, Boolean>();
    public static final String MODID_HBM = "hbm";
    public static final String MODID_TOP = "theoneprobe";

    public static boolean isLoaded(String modid) {
        return LOADED_CACHE.computeIfAbsent(modid, Loader::isModLoaded);
    }

    @Nullable
    public static URI getModUri(String modID) {
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modID);
        if (mod == null) {
            return null;
        }
        File source = mod.getSource();
        return source != null ? source.toURI() : null;
    }

    public static Map<String, Class<?>> getClassesInPackage(String packageName) {
        HashMap classes = new HashMap();
        String path = packageName.replace('.', '/');
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(path);
            block9: while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                String protocol = resource.getProtocol();
                if ("file".equals(protocol)) {
                    File dir = new File(resource.toURI());
                    ModCompatManager.findClassesInDirPackage(packageName, dir, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarInputStream jarStream = new JarInputStream(resource.openStream());
                block10: while (true) {
                    JarEntry entry;
                    while ((entry = jarStream.getNextJarEntry()) != null) {
                        String name = entry.getName();
                        if (!name.startsWith(path) || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.replace('/', '.').substring(0, name.length() - 6);
                        try {
                            Class<?> clazz = Class.forName(className);
                            classes.put(clazz.getSimpleName(), clazz);
                            continue block10;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    continue block9;
                    {
                        continue block10;
                        break;
                    }
                    break;
                }
                finally {
                    jarStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    private static void findClassesInDirPackage(String packageName, File directory, Map<String, Class<?>> classes) {
        if (!directory.exists()) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                ModCompatManager.findClassesInDirPackage(ModCompatManager.jvmdowngrader$concat$findClassesInDirPackage$1(packageName, file.getName()), file, classes);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = ModCompatManager.jvmdowngrader$concat$findClassesInDirPackage$1(packageName, file.getName().substring(0, file.getName().length() - 6));
            try {
                Class<?> clazz = Class.forName(className);
                classes.put(clazz.getSimpleName(), clazz);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$findClassesInDirPackage$1(String string, String string2) {
        return string + "." + string2;
    }
}

