/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.command;

import com.google.gson.JsonParseException;
import com.norwood.mcheli.MCH_BaseInfo;
import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.info.ContentRegistries;
import com.norwood.mcheli.helper.info.ContentRegistry;
import com.norwood.mcheli.helper.info.emitters.IEmitter;
import com.norwood.mcheli.helper.info.emitters.YamlEmitter;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.multiplay.MultiplayerHandler;
import com.norwood.mcheli.networking.packet.PacketHandleCommand;
import com.norwood.mcheli.networking.packet.PacketSyncServerSettings;
import com.norwood.mcheli.networking.packet.PacketTitle;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.tank.MCH_TankInfo;
import com.norwood.mcheli.throwable.MCH_ThrowableInfo;
import com.norwood.mcheli.vehicle.MCH_VehicleInfo;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandGameMode;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.CommandEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class MCH_Command
extends CommandBase {
    public static final String CMD_GET_SS = "sendss";
    public static final String CMD_MOD_LIST = "modlist";
    public static final String CMD_RECONFIG = "reconfig";
    public static final String CMD_TITLE = "title";
    public static final String CMD_FILL = "fill";
    public static final String CMD_STATUS = "status";
    public static final String CMD_KILL_ENTITY = "killentity";
    public static final String CMD_REMOVE_ENTITY = "removeentity";
    public static final String CMD_ATTACK_ENTITY = "attackentity";
    public static final String CMD_SHOW_BB = "showboundingbox";
    public static final String CMD_DELAY_BB = "delayhitbox";
    public static final String CMD_LIST = "list";
    public static final String CMD_DUMP_YAML = "dumpyaml";
    public static final String[] ALL_COMMAND = new String[]{"sendss", "modlist", "reconfig", "title", "fill", "status", "killentity", "removeentity", "attackentity", "showboundingbox", "list", "delayhitbox", "dumpyaml"};
    public static final MCH_Command instance = new MCH_Command();
    private static final Pattern sanitize = Pattern.compile("[^a-zA-Z0-9._-]");

    public static boolean canUseCommand(Entity player) {
        return player instanceof EntityPlayer && instance.canCommandSenderUseCommand((ICommandSender)player);
    }

    public static boolean checkCommandPermission(MinecraftServer server, ICommandSender sender, String cmd) {
        if (new CommandGameMode().func_184882_a(server, sender)) {
            return true;
        }
        if (sender instanceof EntityPlayer && !cmd.isEmpty()) {
            String playerName = ((EntityPlayer)sender).func_146103_bH().getName();
            for (MCH_Config.CommandPermission c : MCH_Config.CommandPermissionList) {
                if (!c.name.equals(cmd)) continue;
                for (String s : c.players) {
                    if (!s.equalsIgnoreCase(playerName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void onCommandEvent(CommandEvent event) {
        if (event.getCommand() instanceof MCH_Command) {
            if (event.getParameters().length > 0 && !event.getParameters()[0].isEmpty()) {
                if (!MCH_Command.checkCommandPermission(MCH_Utils.getServer(), event.getSender(), event.getParameters()[0])) {
                    event.setCanceled(true);
                    TextComponentTranslation c = new TextComponentTranslation("commands.generic.permission", new Object[0]);
                    c.func_150256_b().func_150238_a(TextFormatting.RED);
                    event.getSender().func_145747_a((ITextComponent)c);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @NotNull
    public String func_71517_b() {
        return "mcheli";
    }

    public boolean canCommandSenderUseCommand(ICommandSender player) {
        return true;
    }

    @NotNull
    public String func_71518_a(@NotNull ICommandSender sender) {
        return "commands.com.norwood.mcheli.usage";
    }

    public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] prm) throws CommandException {
        if (!MCH_Config.EnableCommand.prmBool) {
            return;
        }
        if (prm.length == 0) {
            throw new CommandException("Missing subcommand. Use /mcheli list", new Object[0]);
        }
        String subcommand = prm[0].toLowerCase(Locale.ROOT);
        if (!MCH_Command.checkCommandPermission(server, sender, subcommand)) {
            TextComponentTranslation c = new TextComponentTranslation("commands.generic.permission", new Object[0]);
            c.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_145747_a((ITextComponent)c);
            return;
        }
        switch (subcommand) {
            case "sendss": {
                this.handleSendScreenshot(server, sender, prm);
                break;
            }
            case "modlist": {
                this.handleModList(server, sender, prm);
                break;
            }
            case "reconfig": {
                this.handleReconfig(sender, prm);
                break;
            }
            case "title": {
                this.handleTitle(prm);
                break;
            }
            case "fill": {
                this.executeFill(sender, prm);
                break;
            }
            case "status": {
                this.executeStatus(sender, prm);
                break;
            }
            case "killentity": {
                this.executeKillEntity(sender, prm);
                break;
            }
            case "removeentity": {
                this.executeRemoveEntity(sender, prm);
                break;
            }
            case "attackentity": {
                this.executeAttackEntity(sender, prm);
                break;
            }
            case "showboundingbox": {
                this.handleShowBoundingBox(sender, prm);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "delayhitbox": {
                this.handleDelayHitbox(sender, prm);
                break;
            }
            case "dumpyaml": {
                this.handleDumpYaml(sender, prm);
                break;
            }
            default: {
                throw new CommandException("Unknown mcheli command. Please type /mcheli list", new Object[0]);
            }
        }
    }

    private void handleSendScreenshot(MinecraftServer server, ICommandSender sender, String[] prm) throws CommandException {
        if (prm.length != 2) {
            throw new CommandException("Usage: /mcheli sendss playerName", new Object[0]);
        }
        EntityPlayerMP player = MCH_Command.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)prm[1]);
        PacketHandleCommand.send(player, PacketHandleCommand.CommandAction.NONE, prm[1]);
    }

    private void handleModList(MinecraftServer server, ICommandSender sender, String[] prm) throws CommandException {
        if (prm.length < 2) {
            throw new CommandException("Usage: /mcheli modlist playerName...", new Object[0]);
        }
        EntityPlayerMP reqPlayer = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        for (int i = 1; i < prm.length; ++i) {
            EntityPlayerMP player = MCH_Command.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)prm[i]);
            PacketHandleCommand.send(player, PacketHandleCommand.CommandAction.REQUEST_MOD_INFO, MCH_Command.jvmdowngrader$concat$handleModList$1(MultiplayerHandler.getPlayerInfoId((EntityPlayer)reqPlayer)));
        }
    }

    private void handleReconfig(ICommandSender sender, String[] prm) throws CommandException {
        if (prm.length != 1) {
            throw new CommandException("Usage: /mcheli reconfig", new Object[0]);
        }
        MCH_MOD.proxy.reconfig();
        if (!sender.func_130014_f_().field_72995_K) {
            PacketSyncServerSettings.sendAll();
        }
        String msg = MCH_MOD.proxy.isSinglePlayer() ? "Reload com.norwood.mcheli.cfg" : "Reload server side com.norwood.mcheli.cfg";
        sender.func_145747_a((ITextComponent)new TextComponentString(msg));
    }

    private void handleTitle(String[] prm) throws CommandException {
        if (prm.length < 4) {
            throw new WrongUsageException("Usage: /mcheli title time[1~180] position[0~4] message[JSON]", new Object[0]);
        }
        String s = MCH_Command.func_180529_a((String[])prm, (int)3);
        int showTime = Math.max(1, Math.min(180, Integer.parseInt(prm[1])));
        int pos = Math.max(0, Math.min(5, Integer.parseInt(prm[2])));
        try {
            ITextComponent ichatcomponent = ITextComponent.Serializer.func_150699_a((String)s);
            new PacketTitle(ITextComponent.Serializer.func_150696_a((ITextComponent)ichatcomponent), 20 * showTime, pos).sendToClients();
        }
        catch (JsonParseException ex) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
            throw new SyntaxErrorException("com.norwood.mcheli.title.jsonException", new Object[]{root == null ? "" : root.getMessage()});
        }
    }

    private void handleShowBoundingBox(ICommandSender sender, String[] prm) throws CommandException {
        boolean enable;
        if (prm.length != 2) {
            throw new CommandException("Usage: /mcheli showboundingbox true|false", new Object[0]);
        }
        MCH_Config.EnableDebugBoundingBox.prmBool = enable = MCH_Command.func_180527_d((String)prm[1]);
        PacketSyncServerSettings.sendAll();
        sender.func_145747_a((ITextComponent)new TextComponentString(enable ? "Enabled bounding box [F3 + b]" : "Disabled bounding box"));
        MCH_MOD.proxy.save();
    }

    private void handleList(ICommandSender sender) {
        String msg = String.join((CharSequence)", ", ALL_COMMAND);
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$handleList$1(msg)));
    }

    private static String sanitizeFileName(String key) {
        return sanitize.matcher(key).replaceAll("_");
    }

    private void handleDumpYaml(ICommandSender sender, String[] prm) throws CommandException {
        String outDir = prm.length >= 2 ? prm[1] : "mcheli_yaml_dump";
        Path base = Paths.get(outDir, new String[0]);
        YamlEmitter emitter = new YamlEmitter();
        int written = 0;
        try {
            Files.createDirectories(base, new FileAttribute[0]);
            written += this.dumpRegistry(emitter, base.resolve("helicopters"), ContentRegistries.heli());
            written += this.dumpRegistry(emitter, base.resolve("planes"), ContentRegistries.plane());
            written += this.dumpRegistry(emitter, base.resolve("ships"), ContentRegistries.ship());
            written += this.dumpRegistry(emitter, base.resolve("tanks"), ContentRegistries.tank());
            written += this.dumpRegistry(emitter, base.resolve("vehicles"), ContentRegistries.vehicle());
            written += this.dumpWeapons(emitter, base.resolve("weapons"), ContentRegistries.weapon());
            written += this.dumpThrowable(emitter, base.resolve("throwable"), ContentRegistries.throwable());
            sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$handleDumpYaml$1(written += this.dumpHud(emitter, base.resolve("hud"), ContentRegistries.hud()), String.valueOf(base.toAbsolutePath()))));
        }
        catch (IOException e) {
            throw new CommandException(MCH_Command.jvmdowngrader$concat$handleDumpYaml$1(e.getMessage()), new Object[0]);
        }
        catch (Exception e) {
            throw new CommandException(MCH_Command.jvmdowngrader$concat$handleDumpYaml$2(e.getMessage()), new Object[0]);
        }
    }

    private int dumpRegistry(IEmitter emitter, Path dir, ContentRegistry<? extends MCH_BaseInfo> reg) throws IOException {
        int count = 0;
        if (reg == null) {
            return 0;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        for (Map.Entry<String, ? extends MCH_BaseInfo> e : reg.entries()) {
            String content;
            String key = MCH_Command.sanitizeFileName(e.getKey());
            Path out = dir.resolve(MCH_Command.jvmdowngrader$concat$dumpRegistry$1(key));
            MCH_BaseInfo info = e.getValue();
            if (info instanceof MCH_HeliInfo) {
                content = emitter.emitHelicopter((MCH_HeliInfo)info);
            } else if (info instanceof MCH_PlaneInfo) {
                content = emitter.emitPlane((MCH_PlaneInfo)info);
            } else if (info instanceof MCH_ShipInfo) {
                content = emitter.emitShip((MCH_ShipInfo)info);
            } else if (info instanceof MCH_TankInfo) {
                content = emitter.emitTank((MCH_TankInfo)info);
            } else {
                if (!(info instanceof MCH_VehicleInfo)) continue;
                content = emitter.emitVehicle((MCH_VehicleInfo)info);
            }
            YamlEmitter.writeTo(out, content);
            ++count;
        }
        return count;
    }

    private int dumpWeapons(IEmitter emitter, Path dir, ContentRegistry<MCH_WeaponInfo> reg) throws IOException {
        int count = 0;
        if (reg == null) {
            return 0;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        for (Map.Entry<String, MCH_WeaponInfo> e : reg.entries()) {
            String key = MCH_Command.sanitizeFileName(e.getKey());
            Path out = dir.resolve(MCH_Command.jvmdowngrader$concat$dumpRegistry$1(key));
            YamlEmitter.writeTo(out, emitter.emitWeapon(e.getValue()));
            ++count;
        }
        return count;
    }

    private int dumpThrowable(IEmitter emitter, Path dir, ContentRegistry<MCH_ThrowableInfo> reg) throws IOException {
        int count = 0;
        if (reg == null) {
            return 0;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        for (Map.Entry<String, MCH_ThrowableInfo> e : reg.entries()) {
            String key = MCH_Command.sanitizeFileName(e.getKey());
            Path out = dir.resolve(MCH_Command.jvmdowngrader$concat$dumpRegistry$1(key));
            YamlEmitter.writeTo(out, emitter.emitThrowable(e.getValue()));
            ++count;
        }
        return count;
    }

    private int dumpHud(IEmitter emitter, Path dir, ContentRegistry<MCH_Hud> reg) throws IOException {
        int count = 0;
        if (reg == null) {
            return 0;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        for (Map.Entry<String, MCH_Hud> e : reg.entries()) {
            String key = MCH_Command.sanitizeFileName(e.getKey());
            Path out = dir.resolve(MCH_Command.jvmdowngrader$concat$dumpRegistry$1(key));
            YamlEmitter.writeTo(out, emitter.emitHud(e.getValue()));
            ++count;
        }
        return count;
    }

    private void handleDelayHitbox(ICommandSender sender, String[] prm) throws CommandException {
        if (prm.length == 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$handleDelayHitbox$1(MCH_Config.HitBoxDelayTick.prmInt)));
            return;
        }
        if (prm.length != 2) {
            throw new CommandException("Usage: /mcheli delayhitbox 0 ~ 50", new Object[0]);
        }
        MCH_Config.HitBoxDelayTick.prmInt = Math.min(50, MCH_Command.func_175755_a((String)prm[1]));
        MCH_MOD.proxy.save();
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$handleDelayHitbox$1(MCH_Config.HitBoxDelayTick.prmInt)));
    }

    private void executeAttackEntity(ICommandSender sender, String[] args2) throws WrongUsageException {
        if (args2.length < 3) {
            throw new WrongUsageException("/mcheli attackentity <entity class name : example1 EntityBat , example2 minecraft.entity.passive> <damage> [damage source]", new Object[0]);
        }
        String className = args2[1].toLowerCase();
        float damage = Float.parseFloat(args2[2]);
        String damageName = args2.length >= 4 ? args2[3].toLowerCase() : "";
        DamageSource ds = DamageSource.field_76377_j;
        if (!damageName.isEmpty()) {
            switch (damageName) {
                case "player": {
                    if (!(sender instanceof EntityPlayer)) break;
                    ds = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)sender));
                    break;
                }
                case "anvil": {
                    ds = DamageSource.field_82728_o;
                    break;
                }
                case "cactus": {
                    ds = DamageSource.field_76367_g;
                    break;
                }
                case "drown": {
                    ds = DamageSource.field_76369_e;
                    break;
                }
                case "fall": {
                    ds = DamageSource.field_76379_h;
                    break;
                }
                case "fallingblock": {
                    ds = DamageSource.field_82729_p;
                    break;
                }
                case "generic": {
                    ds = DamageSource.field_76377_j;
                    break;
                }
                case "infire": {
                    ds = DamageSource.field_76372_a;
                    break;
                }
                case "inwall": {
                    ds = DamageSource.field_76368_d;
                    break;
                }
                case "lava": {
                    ds = DamageSource.field_76371_c;
                    break;
                }
                case "magic": {
                    ds = DamageSource.field_76376_m;
                    break;
                }
                case "onfire": {
                    ds = DamageSource.field_76370_b;
                    break;
                }
                case "starve": {
                    ds = DamageSource.field_76366_f;
                    break;
                }
                case "wither": {
                    ds = DamageSource.field_82727_n;
                }
            }
        }
        int attacked = 0;
        List list = sender.func_130014_f_().field_72996_f;
        for (Entity entity : list) {
            if (entity == null || entity instanceof EntityPlayer || !entity.getClass().getName().toLowerCase().contains(className)) continue;
            entity.func_70097_a(ds, damage);
            ++attacked;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$executeAttackEntity$1(attacked, args2[1], damage)));
    }

    private void executeKillEntity(ICommandSender sender, String[] args2) throws WrongUsageException {
        if (args2.length < 2) {
            throw new WrongUsageException("/mcheli killentity <entity class name : example1 EntityBat , example2 minecraft.entity.passive>", new Object[0]);
        }
        String className = args2[1].toLowerCase();
        int killed = 0;
        List list = sender.func_130014_f_().field_72996_f;
        for (Entity entity : list) {
            if (entity == null || entity instanceof EntityPlayer || !entity.getClass().getName().toLowerCase().contains(className)) continue;
            entity.func_70106_y();
            ++killed;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$executeKillEntity$1(killed, args2[1])));
    }

    private void executeRemoveEntity(ICommandSender sender, String[] args2) throws WrongUsageException {
        if (args2.length < 2) {
            throw new WrongUsageException("/mcheli removeentity <entity class name : example1 EntityBat , example2 minecraft.entity.passive>", new Object[0]);
        }
        String className = args2[1].toLowerCase();
        List list = sender.func_130014_f_().field_72996_f;
        int removed = 0;
        for (Entity entity : list) {
            if (entity == null || entity instanceof EntityPlayer || !entity.getClass().getName().toLowerCase().contains(className)) continue;
            entity.field_70128_L = true;
            ++removed;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$executeRemoveEntity$1(removed, args2[1])));
    }

    private void executeStatus(ICommandSender sender, String[] args2) throws WrongUsageException {
        if (args2.length < 2) {
            throw new WrongUsageException("/mcheli status <entity or tile> [min num]", new Object[0]);
        }
        if (args2[1].equalsIgnoreCase("entity")) {
            this.executeStatusSub(sender, args2, "Server loaded Entity List", sender.func_130014_f_().field_72996_f);
        } else if (args2[1].equalsIgnoreCase("tile")) {
            this.executeStatusSub(sender, args2, "Server loaded Tile Entity List", sender.func_130014_f_().field_147482_g);
        }
    }

    private void executeStatusSub(ICommandSender sender, String[] args2, String title, List<?> list) {
        int minNum = args2.length >= 3 ? Integer.parseInt(args2[2]) : 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Object o : list) {
            String key = o.getClass().getName();
            if (map.containsKey(key)) {
                map.put(key, (Integer)map.get(key) + 1);
                continue;
            }
            map.put(key, 1);
        }
        ArrayList entries = new ArrayList(map.entrySet());
        entries.sort(Comparator.comparing(Map.Entry::getKey));
        boolean send = false;
        sender.func_145747_a((ITextComponent)new TextComponentString(MCH_Command.jvmdowngrader$concat$executeStatusSub$1(title)));
        for (Map.Entry entry : entries) {
            if ((Integer)entry.getValue() < minNum) continue;
            String msg = MCH_Command.jvmdowngrader$concat$executeStatusSub$1((String)entry.getKey(), String.valueOf(entry.getValue()));
            System.out.println(msg);
            sender.func_145747_a((ITextComponent)new TextComponentString(msg));
            send = true;
        }
        if (!send) {
            System.out.println("none");
            sender.func_145747_a((ITextComponent)new TextComponentString("none"));
        }
    }

    public void executeFill(ICommandSender sender, String[] args2) throws CommandException {
        int t;
        if (args2.length < 8) {
            throw new WrongUsageException("/mcheli fill <x1> <y1> <z1> <x2> <y2> <z2> <block name> [meta data] [oldBlockHandling] [data tag]", new Object[0]);
        }
        int x1 = sender.func_180425_c().func_177958_n();
        int y1 = sender.func_180425_c().func_177956_o();
        int z1 = sender.func_180425_c().func_177952_p();
        int x2 = sender.func_180425_c().func_177958_n();
        int y2 = sender.func_180425_c().func_177956_o();
        int z2 = sender.func_180425_c().func_177952_p();
        x1 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)x1, (String)args2[1], (boolean)true).func_179628_a());
        y1 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)y1, (String)args2[2], (boolean)true).func_179628_a());
        z1 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)z1, (String)args2[3], (boolean)true).func_179628_a());
        x2 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)x2, (String)args2[4], (boolean)true).func_179628_a());
        y2 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)y2, (String)args2[5], (boolean)true).func_179628_a());
        z2 = MathHelper.func_76128_c((double)MCH_Command.func_175770_a((double)z2, (String)args2[6], (boolean)true).func_179628_a());
        Block block = CommandBase.func_147180_g((ICommandSender)sender, (String)args2[7]);
        IBlockState iblockstate = block.func_176223_P();
        if (args2.length >= 9) {
            iblockstate = MCH_Command.func_190794_a((Block)block, (String)args2[8]);
        }
        World world = sender.func_130014_f_();
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (z1 > z2) {
            t = z1;
            z1 = z2;
            z2 = t;
        }
        if (y1 >= 0 && y2 < 256) {
            int blockNum = (x2 - x1 + 1) * (y2 - y1 + 1) * (z2 - z1 + 1);
            if (blockNum > 3000000) {
                throw new CommandException(MCH_Command.jvmdowngrader$concat$executeFill$1(blockNum), new Object[]{blockNum, 0x320000});
            }
            boolean result = false;
            boolean keep = args2.length >= 10 && args2[9].equals("keep");
            boolean destroy = args2.length >= 10 && args2[9].equals("destroy");
            boolean override = args2.length >= 10 && args2[9].equals("override");
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            boolean flag = false;
            if (args2.length >= 11 && block.hasTileEntity(iblockstate)) {
                String s = MCH_Command.func_147178_a((ICommandSender)sender, (String[])args2, (int)10).func_150260_c();
                try {
                    nbttagcompound = JsonToNBT.func_180713_a((String)s);
                    flag = true;
                }
                catch (NBTException var27) {
                    throw new CommandException("commands.setblock.tagError", new Object[]{var27.getMessage()});
                }
            }
            for (int x = x1; x <= x2; ++x) {
                for (int y = y1; y <= y2; ++y) {
                    for (int z = z1; z <= z2; ++z) {
                        TileEntity tileentity;
                        TileEntity block2;
                        BlockPos blockpos = new BlockPos(x, y, z);
                        if (!world.func_175667_e(blockpos) || !(world.func_175623_d(blockpos) ? !override : !keep)) continue;
                        if (destroy) {
                            world.func_175655_b(blockpos, false);
                        }
                        if ((block2 = world.func_175625_s(blockpos)) instanceof IInventory) {
                            IInventory ii = (IInventory)block2;
                            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                                ItemStack is = ii.func_70304_b(i);
                                if (is.func_190926_b()) continue;
                                is.func_190920_e(0);
                            }
                        }
                        if (!world.func_180501_a(blockpos, iblockstate, 3)) continue;
                        if (flag && (tileentity = world.func_175625_s(blockpos)) != null) {
                            nbttagcompound.func_74768_a("x", x);
                            nbttagcompound.func_74768_a("y", y);
                            nbttagcompound.func_74768_a("z", z);
                            tileentity.func_145839_a(nbttagcompound);
                        }
                        result = true;
                    }
                }
            }
            if (!result) {
                throw new CommandException("commands.setblock.noChange", new Object[0]);
            }
        } else {
            throw new CommandException("commands.setblock.outOfWorld", new Object[0]);
        }
        MCH_Command.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.setblock.success", (Object[])new Object[0]);
    }

    @NotNull
    public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String @NotNull [] prm, BlockPos targetPos) {
        if (!MCH_Config.EnableCommand.prmBool) {
            return super.func_184883_a(server, sender, prm, targetPos);
        }
        if (prm.length <= 1) {
            return MCH_Command.func_71530_a((String[])prm, (String[])ALL_COMMAND);
        }
        if (prm[0].equalsIgnoreCase(CMD_GET_SS)) {
            if (prm.length == 2) {
                return MCH_Command.func_71530_a((String[])prm, (String[])server.func_71213_z());
            }
        } else {
            if (prm[0].equalsIgnoreCase(CMD_MOD_LIST)) {
                return MCH_Command.func_71530_a((String[])prm, (String[])server.func_71213_z());
            }
            if (prm[0].equalsIgnoreCase(CMD_FILL)) {
                if ((prm.length == 2 || prm.length == 5) && sender instanceof Entity) {
                    Entity entity = (Entity)sender;
                    ArrayList<String> a = new ArrayList<String>();
                    int x = entity.field_70165_t < 0.0 ? (int)(entity.field_70165_t - 1.0) : (int)entity.field_70165_t;
                    int z = entity.field_70161_v < 0.0 ? (int)(entity.field_70161_v - 1.0) : (int)entity.field_70161_v;
                    a.add(MCH_Command.jvmdowngrader$concat$getTabCompletions$1(x, (int)(entity.field_70163_u + 0.5), z));
                    return a;
                }
                return prm.length == 10 ? MCH_Command.func_71530_a((String[])prm, (String[])new String[]{"replace", "destroy", "keep", "override"}) : (prm.length == 8 ? MCH_Command.func_175762_a((String[])prm, (Collection)Block.field_149771_c.func_148742_b()) : null);
            }
            if (prm[0].equalsIgnoreCase(CMD_STATUS)) {
                if (prm.length == 2) {
                    return MCH_Command.func_71530_a((String[])prm, (String[])new String[]{"entity", "tile"});
                }
            } else if (prm[0].equalsIgnoreCase(CMD_ATTACK_ENTITY)) {
                if (prm.length == 4) {
                    return MCH_Command.func_71530_a((String[])prm, (String[])new String[]{"player", "inFire", "onFire", "lava", "inWall", "drown", "starve", "cactus", "fall", "outOfWorld", "generic", "magic", "wither", "anvil", "fallingBlock"});
                }
            } else if (prm[0].equalsIgnoreCase(CMD_SHOW_BB) && prm.length == 2) {
                return MCH_Command.func_71530_a((String[])prm, (String[])new String[]{"true", "false"});
            }
        }
        return super.func_184883_a(server, sender, prm, targetPos);
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleModList$1(int n) {
        return "" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleList$1(String string) {
        return "/mcheli command list : " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleDumpYaml$1(int n, String string) {
        return "Dumped " + n + " YAML files to " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleDumpYaml$1(String string) {
        return "Failed to dump YAML: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleDumpYaml$2(String string) {
        return "YAML emission error: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$dumpRegistry$1(String string) {
        return string + ".yml";
    }

    private static /* synthetic */ String jvmdowngrader$concat$handleDelayHitbox$1(int n) {
        return "Current delay of hitbox = " + n + " [0 ~ 50]";
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeAttackEntity$1(int n, String string, float f) {
        return n + " entity attacked(" + string + ", damage=" + f + ").";
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeKillEntity$1(int n, String string) {
        return n + " entity killed(" + string + ").";
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeRemoveEntity$1(int n, String string) {
        return n + " entity removed(" + string + ").";
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeStatusSub$1(String string) {
        return "--- " + string + " ---";
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeStatusSub$1(String string, String string2) {
        return " " + string + " : " + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$executeFill$1(int n) {
        return "commands.setblock.tooManyBlocks " + n + " limit=327680";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getTabCompletions$1(int n, int n2, int n3) {
        return n + " " + n2 + " " + n3;
    }
}

