/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.block;

import com.norwood.mcheli.MCH_IRecipeList;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.MCH_ModelManager;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_AircraftInfoManager;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.plane.MCP_PlaneInfoManager;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.ship.MCH_ShipInfoManager;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import com.norwood.mcheli.weapon.MCH_WeaponInfoManager;
import com.norwood.mcheli.wrapper.modelloader.W_ModelCustom;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class MCH_CurrentRecipe {
    public final IRecipe recipe;
    public final int index;
    public final String displayName;
    public final List<ResourceLocation> descTexture;
    private final MCH_AircraftInfo acInfo;
    public List<String> infoItem;
    public List<String> infoData;
    public int modelRot;
    private int descMaxPage;
    private int descPage;
    private W_ModelCustom model;
    private ResourceLocation modelTexture;

    public MCH_CurrentRecipe(MCH_IRecipeList list, int idx) {
        this.recipe = list.getRecipeListSize() > 0 ? list.getRecipe(idx) : null;
        this.index = idx;
        this.displayName = this.recipe != null ? this.recipe.func_77571_b().func_82833_r() : "None";
        this.descTexture = this.getDescTexture(this.recipe);
        this.descPage = 0;
        this.descMaxPage = this.descTexture.size();
        MCH_AircraftInfo info = null;
        if (list instanceof MCH_AircraftInfoManager && (info = ((MCH_AircraftInfoManager)list).getAcInfoFromItem(this.recipe)) != null) {
            ++this.descMaxPage;
            String dir = info.getDirectoryName();
            String name = info.name;
            this.model = MCH_ModelManager.get(dir, name);
            if (this.model != null) {
                this.modelTexture = new ResourceLocation("mcheli", MCH_CurrentRecipe.jvmdowngrader$concat$$init$$1(dir, name));
                ++this.descMaxPage;
                this.modelRot = list instanceof MCP_PlaneInfoManager || list instanceof MCH_ShipInfoManager ? 0 : 1;
            }
        }
        this.getAcInfoText(info);
        this.acInfo = info;
    }

    private void getAcInfoText(MCH_AircraftInfo info) {
        this.infoItem = new ArrayList<String>();
        this.infoData = new ArrayList<String>();
        if (info != null) {
            MCH_AircraftInfo pinfo;
            this.getAcInfoTextSub("Name", info.getItemStack().func_82833_r());
            this.getAcInfoTextSub("HP", MCH_CurrentRecipe.jvmdowngrader$concat$getAcInfoText$1(info.maxHp));
            int seatNum = !info.isUAV ? info.getNumSeat() : info.getNumSeat() - 1;
            this.getAcInfoTextSub("Num of Seat", MCH_CurrentRecipe.jvmdowngrader$concat$getAcInfoText$1(seatNum));
            this.getAcInfoTextSub("GunnerMode", info.isEnableGunnerMode ? "YES" : "NO");
            this.getAcInfoTextSub("NightVision", info.isEnableNightVision ? "YES" : "NO");
            this.getAcInfoTextSub("Radar", info.isEnableEntityRadar ? "YES" : "NO");
            this.getAcInfoTextSub("Inventory", MCH_CurrentRecipe.jvmdowngrader$concat$getAcInfoText$1(info.inventorySize));
            if (info instanceof MCH_PlaneInfo) {
                pinfo = (MCH_PlaneInfo)info;
                this.getAcInfoTextSub("VTOL", pinfo.isEnableVtol ? "YES" : "NO");
            }
            if (info instanceof MCH_ShipInfo) {
                pinfo = (MCH_ShipInfo)info;
                this.getAcInfoTextSub("Submersible", ((MCH_ShipInfo)pinfo).isEnableVtol ? "YES" : "NO");
            }
            if (info.getWeaponCount() > 0) {
                this.getAcInfoTextSub("Armed----------------");
                for (int i = 0; i < info.getWeaponCount(); ++i) {
                    String type = info.getWeaponSetById((int)i).type;
                    MCH_WeaponInfo winfo = MCH_WeaponInfoManager.get(type);
                    if (winfo != null) {
                        this.getAcInfoTextSub(winfo.getWeaponTypeName(), winfo.displayName);
                        continue;
                    }
                    this.getAcInfoTextSub("ERROR", MCH_CurrentRecipe.jvmdowngrader$concat$getAcInfoText$2(i + 1));
                }
            }
        }
    }

    private void getAcInfoTextSub(String item, String data) {
        this.infoItem.add(MCH_CurrentRecipe.jvmdowngrader$concat$getAcInfoTextSub$1(item));
        this.infoData.add(data);
    }

    private void getAcInfoTextSub(String item) {
        this.infoItem.add(item);
        this.infoData.add("");
    }

    public void switchNextPage() {
        this.descPage = this.descMaxPage >= 2 ? (this.descPage + 1) % this.descMaxPage : 0;
    }

    public void switchPrevPage() {
        --this.descPage;
        this.descPage = this.descPage < 0 && this.descMaxPage >= 2 ? this.descMaxPage - 1 : 0;
    }

    public int getDescCurrentPage() {
        return this.descPage;
    }

    public void setDescCurrentPage(int page) {
        this.descPage = this.descMaxPage > 0 ? (page < this.descMaxPage ? page : this.descMaxPage - 1) : 0;
    }

    public int getDescMaxPage() {
        return this.descMaxPage;
    }

    @Nullable
    public ResourceLocation getCurrentPageTexture() {
        return this.descPage < this.descTexture.size() ? this.descTexture.get(this.descPage) : null;
    }

    public W_ModelCustom getModel() {
        return this.model;
    }

    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    @Nullable
    public MCH_AircraftInfo getAcInfo() {
        return this.acInfo;
    }

    public boolean isCurrentPageTexture() {
        return this.descPage >= 0 && this.descPage < this.descTexture.size();
    }

    public boolean isCurrentPageModel() {
        return this.getAcInfo() != null && this.getModel() != null && this.descPage == this.descTexture.size();
    }

    public boolean isCurrentPageAcInfo() {
        return this.getAcInfo() != null && this.descPage == this.descMaxPage - 1;
    }

    private List<ResourceLocation> getDescTexture(@Nullable IRecipe r) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        if (r != null) {
            for (int i = 0; i < 20; ++i) {
                File filePng;
                String itemName = r.func_77571_b().func_77977_a();
                if (itemName.startsWith("tile.")) {
                    itemName = itemName.substring(5);
                }
                if (itemName.contains(":")) {
                    itemName = itemName.substring(itemName.indexOf(":") + 1);
                }
                if (!(filePng = new File(MCH_MOD.sourcePath, MCH_CurrentRecipe.jvmdowngrader$concat$getDescTexture$1(itemName = MCH_CurrentRecipe.jvmdowngrader$concat$getDescTexture$1(itemName, i)))).exists()) continue;
                list.add(new ResourceLocation("mcheli", itemName));
            }
        }
        return list;
    }

    private static /* synthetic */ String jvmdowngrader$concat$$init$$1(String string, String string2) {
        return "textures/" + string + "/" + string2 + ".png";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAcInfoText$1(int n) {
        return "" + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAcInfoText$2(int n) {
        return "Not found weapon " + n;
    }

    private static /* synthetic */ String jvmdowngrader$concat$getAcInfoTextSub$1(String string) {
        return string + " :";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getDescTexture$1(String string, int n) {
        return "textures/drafting_table_desc/" + string + "#" + n + ".png";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getDescTexture$1(String string) {
        return "/assets/mcheli/" + string;
    }
}

