/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.aircraft;

import com.norwood.mcheli.MCH_Lib;
import lombok.Generated;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={EnumBoundingBoxType.class})
public class MCH_BoundingBox {
    public AxisAlignedBB boundingBox;
    public AxisAlignedBB backupBoundingBox;
    public double offsetX;
    public double offsetY;
    public double offsetZ;
    public float width;
    public float widthZ;
    public float height;
    public float halfWidth;
    public float halfHeight;
    public float halfDepth;
    public Vec3d rotatedOffset;
    public Vec3d nowPos;
    public Vec3d prevPos;
    public float damageFactor;
    public EnumBoundingBoxType boundingBoxType = EnumBoundingBoxType.DEFAULT;
    public String name = "";
    public float rotationYaw = 0.0f;
    public float rotationPitch = 0.0f;
    public float rotationRoll = 0.0f;
    public Vec3d axisX = new Vec3d(1.0, 0.0, 0.0);
    public Vec3d axisY = new Vec3d(0.0, 1.0, 0.0);
    public Vec3d axisZ = new Vec3d(0.0, 0.0, 1.0);
    public Vec3d center;
    public float localRotYaw = 0.0f;
    public float localRotPitch = 0.0f;
    public float localRotRoll = 0.0f;

    public MCH_BoundingBox(double x, double y, double z, float w, float h, float df) {
        this(x, y, z, w, h, w, df);
    }

    public MCH_BoundingBox(double posX, double posY, double posZ, float widthX, float height, float widthZ, float df) {
        this.offsetX = posX;
        this.offsetY = posY;
        this.offsetZ = posZ;
        this.width = widthX;
        this.widthZ = widthZ;
        this.height = height;
        this.halfWidth = widthX / 2.0f;
        this.halfHeight = height / 2.0f;
        this.halfDepth = widthZ / 2.0f;
        this.damageFactor = df;
        this.center = new Vec3d(posX, posY, posZ);
        this.nowPos = new Vec3d(posX, posY, posZ);
        this.prevPos = new Vec3d(posX, posY, posZ);
        this.boundingBox = new AxisAlignedBB(posX - (double)this.halfWidth, posY - (double)this.halfHeight, posZ - (double)this.halfDepth, posX + (double)this.halfWidth, posY + (double)this.halfHeight, posZ + (double)this.halfDepth);
        this.backupBoundingBox = MCH_BoundingBox.copyAABB(this.boundingBox);
    }

    public MCH_BoundingBox copy() {
        MCH_BoundingBox bb = new MCH_BoundingBox(this.offsetX, this.offsetY, this.offsetZ, this.width, this.height, this.widthZ, this.damageFactor);
        bb.rotationYaw = this.rotationYaw;
        bb.rotationPitch = this.rotationPitch;
        bb.rotationRoll = this.rotationRoll;
        bb.axisX = new Vec3d(this.axisX.field_72450_a, this.axisX.field_72448_b, this.axisX.field_72449_c);
        bb.axisY = new Vec3d(this.axisY.field_72450_a, this.axisY.field_72448_b, this.axisY.field_72449_c);
        bb.axisZ = new Vec3d(this.axisZ.field_72450_a, this.axisZ.field_72448_b, this.axisZ.field_72449_c);
        bb.center = new Vec3d(this.center.field_72450_a, this.center.field_72448_b, this.center.field_72449_c);
        bb.halfWidth = this.halfWidth;
        bb.halfHeight = this.halfHeight;
        bb.halfDepth = this.halfDepth;
        if (this.rotatedOffset != null) {
            bb.rotatedOffset = new Vec3d(this.rotatedOffset.field_72450_a, this.rotatedOffset.field_72448_b, this.rotatedOffset.field_72449_c);
        }
        bb.nowPos = new Vec3d(this.nowPos.field_72450_a, this.nowPos.field_72448_b, this.nowPos.field_72449_c);
        bb.prevPos = new Vec3d(this.prevPos.field_72450_a, this.prevPos.field_72448_b, this.prevPos.field_72449_c);
        bb.boundingBox = MCH_BoundingBox.copyAABB(this.boundingBox);
        bb.backupBoundingBox = MCH_BoundingBox.copyAABB(this.backupBoundingBox);
        bb.boundingBoxType = this.boundingBoxType;
        bb.name = this.name;
        return bb;
    }

    public void updatePosition(double posX, double posY, double posZ, float yaw, float pitch, float roll) {
        this.rotationYaw = yaw;
        this.rotationPitch = pitch;
        this.rotationRoll = roll;
        float extraYaw = yaw;
        float extraPitch = pitch;
        float extraRoll = roll;
        if (this.boundingBoxType == EnumBoundingBoxType.TURRET) {
            extraYaw += this.localRotYaw;
            extraPitch += this.localRotPitch;
            extraRoll += this.localRotRoll;
        }
        Vec3d localOffset = new Vec3d(this.offsetX, this.offsetY, this.offsetZ);
        this.rotatedOffset = MCH_Lib.RotVec3(localOffset, -extraYaw, -extraPitch, -extraRoll);
        double cx = posX + this.rotatedOffset.field_72450_a;
        double cy = posY + this.rotatedOffset.field_72448_b;
        double cz = posZ + this.rotatedOffset.field_72449_c;
        this.prevPos = this.nowPos;
        this.nowPos = new Vec3d(cx, cy, cz);
        this.center = new Vec3d(cx, cy, cz);
        this.axisX = MCH_Lib.RotVec3(new Vec3d(1.0, 0.0, 0.0), -extraYaw, -extraPitch, -extraRoll);
        this.axisY = MCH_Lib.RotVec3(new Vec3d(0.0, 1.0, 0.0), -extraYaw, -extraPitch, -extraRoll);
        this.axisZ = MCH_Lib.RotVec3(new Vec3d(0.0, 0.0, 1.0), -extraYaw, -extraPitch, -extraRoll);
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (int xi = -1; xi <= 1; xi += 2) {
            for (int yi = -1; yi <= 1; yi += 2) {
                for (int zi = -1; zi <= 1; zi += 2) {
                    Vec3d cornerLocal = new Vec3d(this.offsetX + (double)((float)xi * this.halfWidth), this.offsetY + (double)((float)yi * this.halfHeight), this.offsetZ + (double)((float)zi * this.halfDepth));
                    Vec3d cornerWorld = MCH_Lib.RotVec3(cornerLocal, -extraYaw, -extraPitch, -extraRoll);
                    double px = posX + cornerWorld.field_72450_a;
                    double py = posY + cornerWorld.field_72448_b;
                    double pz = posZ + cornerWorld.field_72449_c;
                    if (px < minX) {
                        minX = px;
                    }
                    if (py < minY) {
                        minY = py;
                    }
                    if (pz < minZ) {
                        minZ = pz;
                    }
                    if (px > maxX) {
                        maxX = px;
                    }
                    if (py > maxY) {
                        maxY = py;
                    }
                    if (!(pz > maxZ)) continue;
                    maxZ = pz;
                }
            }
        }
        this.backupBoundingBox = MCH_BoundingBox.copyAABB(this.boundingBox);
        this.boundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean intersectsOBB(MCH_BoundingBox other) {
        double rb;
        double ra;
        Vec3d[] A = new Vec3d[]{this.axisX, this.axisY, this.axisZ};
        Vec3d[] B = new Vec3d[]{other.axisX, other.axisY, other.axisZ};
        double[] a = new double[]{this.halfWidth, this.halfHeight, this.halfDepth};
        double[] b = new double[]{other.halfWidth, other.halfHeight, other.halfDepth};
        double[][] R = new double[3][3];
        double[][] absR = new double[3][3];
        double EPS = 1.0E-6;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = A[i].func_72430_b(B[j]);
                absR[i][j] = Math.abs(R[i][j]) + EPS;
            }
        }
        Vec3d d = other.center.func_178788_d(this.center);
        double[] t = new double[]{d.func_72430_b(A[0]), d.func_72430_b(A[1]), d.func_72430_b(A[2])};
        for (int i = 0; i < 3; ++i) {
            ra = a[i];
            rb = b[0] * absR[i][0] + b[1] * absR[i][1] + b[2] * absR[i][2];
            if (!(Math.abs(t[i]) > ra + rb)) continue;
            return false;
        }
        for (int j = 0; j < 3; ++j) {
            ra = a[0] * absR[0][j] + a[1] * absR[1][j] + a[2] * absR[2][j];
            rb = b[j];
            double tProj = Math.abs(t[0] * R[0][j] + t[1] * R[1][j] + t[2] * R[2][j]);
            if (!(tProj > ra + rb)) continue;
            return false;
        }
        ra = a[1] * absR[2][0] + a[2] * absR[1][0];
        rb = b[1] * absR[0][2] + b[2] * absR[0][1];
        if (Math.abs(t[2] * R[1][0] - t[1] * R[2][0]) > ra + rb) {
            return false;
        }
        ra = a[1] * absR[2][1] + a[2] * absR[1][1];
        rb = b[0] * absR[0][2] + b[2] * absR[0][0];
        if (Math.abs(t[2] * R[1][1] - t[1] * R[2][1]) > ra + rb) {
            return false;
        }
        ra = a[1] * absR[2][2] + a[2] * absR[1][2];
        rb = b[0] * absR[0][1] + b[1] * absR[0][0];
        if (Math.abs(t[2] * R[1][2] - t[1] * R[2][2]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[2][0] + a[2] * absR[0][0];
        rb = b[1] * absR[1][2] + b[2] * absR[1][1];
        if (Math.abs(t[0] * R[2][0] - t[2] * R[0][0]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[2][1] + a[2] * absR[0][1];
        rb = b[0] * absR[1][2] + b[2] * absR[1][0];
        if (Math.abs(t[0] * R[2][1] - t[2] * R[0][1]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[2][2] + a[2] * absR[0][2];
        rb = b[0] * absR[1][1] + b[1] * absR[1][0];
        if (Math.abs(t[0] * R[2][2] - t[2] * R[0][2]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[1][0] + a[1] * absR[0][0];
        rb = b[1] * absR[2][2] + b[2] * absR[2][1];
        if (Math.abs(t[1] * R[0][0] - t[0] * R[1][0]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[1][1] + a[1] * absR[0][1];
        rb = b[0] * absR[2][2] + b[2] * absR[2][0];
        if (Math.abs(t[1] * R[0][1] - t[0] * R[1][1]) > ra + rb) {
            return false;
        }
        ra = a[0] * absR[1][2] + a[1] * absR[0][2];
        rb = b[0] * absR[2][1] + b[1] * absR[2][0];
        return !(Math.abs(t[1] * R[0][2] - t[0] * R[1][2]) > ra + rb);
    }

    public boolean intersectsAABB(AxisAlignedBB aabb) {
        double cx = (aabb.field_72340_a + aabb.field_72336_d) * 0.5;
        double cy = (aabb.field_72338_b + aabb.field_72337_e) * 0.5;
        double cz = (aabb.field_72339_c + aabb.field_72334_f) * 0.5;
        double hx = (aabb.field_72336_d - aabb.field_72340_a) * 0.5;
        double hy = (aabb.field_72337_e - aabb.field_72338_b) * 0.5;
        double hz = (aabb.field_72334_f - aabb.field_72339_c) * 0.5;
        MCH_BoundingBox tmp = new MCH_BoundingBox(cx, cy, cz, (float)(hx * 2.0), (float)(hy * 2.0), (float)(hz * 2.0), 1.0f);
        tmp.center = new Vec3d(cx, cy, cz);
        tmp.halfWidth = (float)hx;
        tmp.halfHeight = (float)hy;
        tmp.halfDepth = (float)hz;
        tmp.axisX = new Vec3d(1.0, 0.0, 0.0);
        tmp.axisY = new Vec3d(0.0, 1.0, 0.0);
        tmp.axisZ = new Vec3d(0.0, 0.0, 1.0);
        return this.intersectsOBB(tmp);
    }

    public String toString() {
        return MCH_BoundingBox.jvmdowngrader$concat$toString$1(String.valueOf(this.boundingBox), String.valueOf(this.backupBoundingBox), this.offsetX, this.offsetY, this.offsetZ, this.width, this.widthZ, this.height, this.halfWidth, this.halfHeight, this.halfDepth, String.valueOf(this.rotatedOffset), String.valueOf(this.nowPos), String.valueOf(this.prevPos), this.damageFactor, String.valueOf((Object)this.boundingBoxType), this.name, this.rotationYaw, this.rotationPitch, this.rotationRoll, String.valueOf(this.axisX), String.valueOf(this.axisY), String.valueOf(this.axisZ), String.valueOf(this.center), this.localRotYaw, this.localRotPitch, this.localRotRoll);
    }

    public static AxisAlignedBB copyAABB(AxisAlignedBB bb) {
        if (bb == null) {
            return null;
        }
        return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
    }

    @Generated
    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    @Generated
    public float getDamageFactor() {
        return this.damageFactor;
    }

    @Generated
    public void setBoundingBoxType(EnumBoundingBoxType boundingBoxType) {
        this.boundingBoxType = boundingBoxType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, double d, double d2, double d3, float f, float f2, float f3, float f4, float f5, float f6, String string3, String string4, String string5, float f7, String string6, String string7, float f8, float f9, float f10, String string8, String string9, String string10, String string11, float f11, float f12, float f13) {
        return "MCH_BoundingBox{boundingBox=" + string + ", backupBoundingBox=" + string2 + ", offsetX=" + d + ", offsetY=" + d2 + ", offsetZ=" + d3 + ", width=" + f + ", widthZ=" + f2 + ", height=" + f3 + ", halfWidth=" + f4 + ", halfHeight=" + f5 + ", halfDepth=" + f6 + ", rotatedOffset=" + string3 + ", nowPos=" + string4 + ", prevPos=" + string5 + ", damageFactor=" + f7 + ", boundingBoxType=" + string6 + ", name='" + string7 + "', rotationYaw=" + f8 + ", rotationPitch=" + f9 + ", rotationRoll=" + f10 + ", axisX=" + string8 + ", axisY=" + string9 + ", axisZ=" + string10 + ", center=" + string11 + ", localRotYaw=" + f11 + ", localRotPitch=" + f12 + ", localRotRoll=" + f13 + "}";
    }

    @NestHost(value=MCH_BoundingBox.class)
    public static enum EnumBoundingBoxType {
        DEFAULT,
        ENGINE,
        TURRET;

    }
}

