/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.aircraft;

import com.norwood.mcheli.MCH_BaseInfo;
import com.norwood.mcheli.RWRType;
import com.norwood.mcheli.RadarType;
import com.norwood.mcheli.aircraft.MCH_BoundingBox;
import com.norwood.mcheli.aircraft.MCH_MobDropOption;
import com.norwood.mcheli.aircraft.MCH_SeatInfo;
import com.norwood.mcheli.aircraft.MCH_SeatRackInfo;
import com.norwood.mcheli.helper.addon.AddonResourceLocation;
import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.helper.info.IItemContent;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.hud.MCH_HudManager;
import com.norwood.mcheli.hud.direct_drawable.DirectDrawable;
import com.norwood.mcheli.hud.direct_drawable.HudBVRLock;
import com.norwood.mcheli.hud.direct_drawable.HudGPS;
import com.norwood.mcheli.hud.direct_drawable.HudMortarRadar;
import com.norwood.mcheli.hud.direct_drawable.HudRWR;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={Wheel.class, WeaponSet.class, WeaponBay.class, Weapon.class, TrackRoller.class, Throttle.class, SearchLight.class, RotPart.class, RideRack.class, RepellingHook.class, ParticleSplash.class, PartWheel.class, PartWeaponChild.class, PartWeapon.class, LandingGear.class, Hatch.class, Flare.class, DrawnPart.class, DrawnPart.DrawnPartBuilderImpl.class, DrawnPart.DrawnPartBuilder.class, CrawlerTrackPrm.class, CrawlerTrack.class, Canopy.class, CameraPosition.class, Camera.class, Camera.CameraBuilderImpl.class, Camera.CameraBuilder.class})
public abstract class MCH_AircraftInfo
extends MCH_BaseInfo
implements IItemContent {
    public final String name;
    public final List<IRecipe> recipe = new ArrayList<IRecipe>();
    public final List<WeaponSet> weaponSetList = new ArrayList<WeaponSet>();
    public final List<MCH_SeatInfo> seatList = new ArrayList<MCH_SeatInfo>();
    public final List<Integer[]> exclusionSeatList = new ArrayList<Integer[]>();
    public final List<MCH_Hud> hudList = new ArrayList<MCH_Hud>();
    public final List<MCH_BoundingBox> extraBoundingBox = new ArrayList<MCH_BoundingBox>();
    public final List<Wheel> wheels = this.getDefaultWheelList();
    public final List<MCH_SeatRackInfo> entityRackList = new ArrayList<MCH_SeatRackInfo>();
    public final MCH_MobDropOption mobDropOption = new MCH_MobDropOption();
    public final List<RepellingHook> repellingHooks = new ArrayList<RepellingHook>();
    public final List<RideRack> rideRacks = new ArrayList<RideRack>();
    public final List<ParticleSplash> particleSplashs = new ArrayList<ParticleSplash>();
    public final List<SearchLight> searchLights = new ArrayList<SearchLight>();
    public final List<CameraPosition> cameraPosition = new ArrayList<CameraPosition>();
    public final List<Hatch> hatchList = new ArrayList<Hatch>();
    public final List<Camera> cameraList = new ArrayList<Camera>();
    public final List<PartWeapon> partWeapon = new ArrayList<PartWeapon>();
    public final List<WeaponBay> partWeaponBay = new ArrayList<WeaponBay>();
    public final List<Canopy> canopyList = new ArrayList<Canopy>();
    public final List<LandingGear> landingGear = new ArrayList<LandingGear>();
    public final List<Throttle> partThrottle = new ArrayList<Throttle>();
    public final List<RotPart> partRotPart = new ArrayList<RotPart>();
    public final List<CrawlerTrack> partCrawlerTrack = new ArrayList<CrawlerTrack>();
    public final List<TrackRoller> partTrackRoller = new ArrayList<TrackRoller>();
    public final List<PartWheel> partWheel = new ArrayList<PartWheel>();
    public final List<PartWheel> partSteeringWheel = new ArrayList<PartWheel>();
    public final List<Hatch> lightHatchList = new ArrayList<Hatch>();
    private final List<String> textureNameList = new ArrayList<String>();
    public Flare flare = new Flare(this);
    public String displayName;
    public HashMap<String, String> displayNameLang = new HashMap();
    public int itemID = 0;
    public List<String> recipeString = new ArrayList<String>();
    public boolean isShapedRecipe = true;
    public String category = "zzz";
    public boolean creativeOnly = false;
    public boolean invulnerable = false;
    public boolean isEnableGunnerMode = false;
    public int cameraZoom = this.getDefaultMaxZoom();
    public boolean isEnableConcurrentGunnerMode = false;
    public boolean isEnableNightVision = false;
    public boolean isEnableEntityRadar = false;
    public boolean isEnableEjectionSeat = false;
    public boolean isEnableParachuting = false;
    public float bodyHeight = 0.7f;
    public float bodyWidth = 2.0f;
    public boolean isFloat = false;
    public float floatOffset = 0.0f;
    public float gravity = -0.04f;
    public float gravityInWater = -0.04f;
    public int maxHp = 50;
    public float armorMinDamage = 0.0f;
    public float armorMaxDamage = 100000.0f;
    public float armorDamageFactor = 1.0f;
    public boolean enableBack = false;
    public int inventorySize = 0;
    public boolean isUAV = false;
    public boolean isSmallUAV = false;
    public boolean isNewUAV;
    public boolean isTargetDrone = false;
    public float autoPilotRot = -0.6f;
    public float onGroundPitch = 0.0f;
    public boolean canMoveOnGround = true;
    public boolean canRotOnGround = true;
    public MCH_Hud hudTvMissile = null;
    public float damageFactor = 0.2f;
    public float submergedDamageHeight = 0.0f;
    public boolean regeneration = false;
    public int maxFuel = 0;
    public float fuelConsumption = 1.0f;
    public float fuelSupplyRange = 0.0f;
    public float ammoSupplyRange = 0.0f;
    public float repairOtherVehiclesRange = 0.0f;
    public int repairOtherVehiclesValue = 10;
    public float stealth = 0.0f;
    public boolean canRide = true;
    public float entityWidth = 1.0f;
    public float entityHeight = 1.0f;
    public float entityPitch = 0.0f;
    public float entityRoll = 0.0f;
    public float stepHeight = this.getDefaultStepHeight();
    public int mobSeatNum = 0;
    public int entityRackNum = 0;
    public float rotorSpeed = this.getDefaultRotorSpeed();
    public boolean enableSeaSurfaceParticle = false;
    public float pivotTurnThrottle = 0.0f;
    public float trackRollerRot = 30.0f;
    public float partWheelRot = 30.0f;
    public float onGroundPitchFactor = 0.0f;
    public float onGroundRollFactor = 0.0f;
    public Vec3d turretPosition = new Vec3d(0.0, 0.0, 0.0);
    public boolean defaultFreelook = false;
    public Vec3d unmountPosition = null;
    public float thirdPersonDist = 4.0f;
    public float markerWidth = 2.0f;
    public float markerHeight = 1.0f;
    public float bbZmin = -1.0f;
    public float bbZmax = 1.0f;
    public float bbZ;
    public boolean alwaysCameraView = false;
    public float cameraRotationSpeed = 100.0f;
    public float speed = 0.1f;
    public float motionFactor = 0.96f;
    public float mobilityYaw = 1.0f;
    public float mobilityPitch = 1.0f;
    public float mobilityRoll = 1.0f;
    public float mobilityYawOnGround = 1.0f;
    public float minRotationPitch = this.getMinRotationPitch();
    public float maxRotationPitch = this.getMaxRotationPitch();
    public float minRotationRoll = this.getMinRotationPitch();
    public float maxRotationRoll = this.getMaxRotationPitch();
    public boolean limitRotation = false;
    public float throttleUpDown = 1.0f;
    public float throttleUpDownOnEntity = 2.0f;
    public int textureCount = 0;
    public float particlesScale = 1.0f;
    public boolean hideEntity = false;
    public boolean smoothShading = true;
    @Nullable
    public ResourceLocation soundMove = null;
    public float soundVolume = 1.0f;
    public float soundPitch = 1.0f;
    public float soundRange = this.getDefaultSoundRange();
    public _IModelCustom model = null;
    public RadarType radarType = RadarType.EARLY_AA;
    public RWRType rwrType = RWRType.DIGITAL;
    public String nameOnModernAARadar = "";
    public String nameOnEarlyAARadar = "";
    public String nameOnModernASRadar = "";
    public String nameOnEarlyASRadar = "";
    public float explosionSizeByCrash = 5.0f;
    public float throttleDownFactor = 1.0f;
    public int chaffUseTime = 100;
    public int chaffWaitTime = 400;
    public int maintenanceUseTime = 20;
    public int maintenanceWaitTime = 300;
    public int engineShutdownThreshold = 20;
    public int apsUseTime = 100;
    public int apsWaitTime = 400;
    public int apsRange = 8;
    public boolean hasRWR = false;
    public int hudType = 0;
    public int weaponGroupType = 0;
    public float armorExplosionDamageMultiplier = 1.0f;
    public boolean hasPhotoelectricJammer = false;
    public float oneProbeScale = 1.0f;
    private String lastWeaponType = "";
    private int lastWeaponIndex = -1;
    private PartWeapon lastWeaponPart = null;
    private List<DirectDrawable> hudCache = null;

    public MCH_AircraftInfo(AddonResourceLocation location, String path) {
        super(location, path);
        this.displayName = this.name = location == null ? "IAMTEST" : location.func_110623_a();
        this.textureNameList.add(this.name);
    }

    public static String[] getCannotReloadItem() {
        return new String[]{"DisplayName", "AddDisplayName", "ItemID", "AddRecipe", "AddShapelessRecipe", "InventorySize", "Sound", "UAV", "SmallUAV", "TargetDrone", "Category"};
    }

    public List<DirectDrawable> getHudCache() {
        if (this.hudCache == null) {
            this.hudCache = this.buildHudCache();
        }
        return this.hudCache;
    }

    private List<DirectDrawable> buildHudCache() {
        ArrayList<DirectDrawable> list = new ArrayList<DirectDrawable>();
        if (this.hasRWR) {
            list.add(HudRWR.INSTANCE);
        }
        list.add(HudGPS.INSTANCE);
        list.add(HudMortarRadar.INSTANCE);
        list.add(HudBVRLock.INSTANCE);
        return list;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.getItem());
    }

    public abstract String getDirectoryName();

    public abstract String getKindName();

    public float getDefaultSoundRange() {
        return 100.0f;
    }

    public List<Wheel> getDefaultWheelList() {
        return new ArrayList<Wheel>();
    }

    public float getDefaultRotorSpeed() {
        return 0.0f;
    }

    private float getDefaultStepHeight() {
        return 0.0f;
    }

    public boolean haveRepellingHook() {
        return !this.repellingHooks.isEmpty();
    }

    public boolean haveFlare() {
        return this.flare.types.length > 0;
    }

    public boolean haveCanopy() {
        return !this.canopyList.isEmpty();
    }

    public boolean haveLandingGear() {
        return !this.landingGear.isEmpty();
    }

    public abstract String getDefaultHudName(int var1);

    @Override
    public boolean validate() throws Exception {
        if (this.cameraPosition.isEmpty()) {
            this.cameraPosition.add(new CameraPosition(this));
        }
        this.bbZ = (this.bbZmax + this.bbZmin) / 2.0f;
        if (this.isTargetDrone) {
            this.isUAV = true;
        }
        if (this.isEnableParachuting && !this.repellingHooks.isEmpty()) {
            this.isEnableParachuting = false;
            this.repellingHooks.clear();
        }
        if (this.isUAV) {
            this.alwaysCameraView = true;
            if (this.seatList.isEmpty()) {
                MCH_SeatInfo s = new MCH_SeatInfo(new Vec3d(0.0, 0.0, 0.0), false);
                this.seatList.add(s);
            }
        }
        this.mobSeatNum = this.seatList.size();
        this.entityRackNum = this.entityRackList.size();
        if (this.getNumSeat() < 1) {
            throw new Exception("At least one seat must be set.");
        }
        if (this.getNumHud() < this.getNumSeat()) {
            for (int i = this.getNumHud(); i < this.getNumSeat(); ++i) {
                this.hudList.add(MCH_HudManager.get(this.getDefaultHudName(i)));
            }
        }
        if (this.getNumSeat() == 1 && this.getNumHud() == 1) {
            this.hudList.add(MCH_HudManager.get(this.getDefaultHudName(1)));
        }
        this.seatList.addAll(this.entityRackList);
        this.entityRackList.clear();
        if (this.hudTvMissile == null) {
            this.hudTvMissile = MCH_HudManager.get("tv_missile");
        }
        if (this.textureNameList.isEmpty()) {
            throw new Exception("At least one texture must be set.");
        }
        if (this.itemID <= 0) {
            // empty if block
        }
        for (int i = 0; i < this.partWeaponBay.size(); ++i) {
            WeaponBay wb = this.partWeaponBay.get(i);
            String[] weaponNames = wb.weaponName.split("\\s*/\\s*");
            if (weaponNames.length == 0) {
                this.partWeaponBay.remove(i);
                continue;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (String s : weaponNames) {
                int id = this.getWeaponIdByName(s);
                if (id < 0) continue;
                list.add(id);
            }
            if (list.isEmpty()) {
                this.partWeaponBay.remove(i);
                continue;
            }
            this.partWeaponBay.get((int)i).weaponIds = list.toArray(new Integer[0]);
        }
        return true;
    }

    public int getInfo_MaxSeatNum() {
        return 30;
    }

    public int getNumSeatAndRack() {
        return this.seatList.size();
    }

    public int getNumSeat() {
        return this.mobSeatNum;
    }

    public int getNumRack() {
        return this.entityRackNum;
    }

    public int getNumHud() {
        return this.hudList.size();
    }

    public float getMaxSpeed() {
        return 0.8f;
    }

    public float getMinRotationPitch() {
        return -89.9f;
    }

    public float getMaxRotationPitch() {
        return 80.0f;
    }

    public float getMinRotationRoll() {
        return -80.0f;
    }

    public float getMaxRotationRoll() {
        return 80.0f;
    }

    public int getDefaultMaxZoom() {
        return 1;
    }

    public boolean haveHatch() {
        return !this.hatchList.isEmpty();
    }

    public boolean havePartCamera() {
        return !this.cameraList.isEmpty();
    }

    public boolean havePartThrottle() {
        return !this.partThrottle.isEmpty();
    }

    public WeaponSet getWeaponSetById(int id) {
        return id >= 0 && id < this.weaponSetList.size() ? this.weaponSetList.get(id) : null;
    }

    public Weapon getWeaponById(int id) {
        WeaponSet ws = this.getWeaponSetById(id);
        return ws != null ? ws.weapons.get(0) : null;
    }

    public int getWeaponIdByName(String s) {
        for (int i = 0; i < this.weaponSetList.size(); ++i) {
            if (!this.weaponSetList.get((int)i).type.equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    public Weapon getWeaponByName(String s) {
        for (int i = 0; i < this.weaponSetList.size(); ++i) {
            if (!this.weaponSetList.get((int)i).type.equalsIgnoreCase(s)) continue;
            return this.getWeaponById(i);
        }
        return null;
    }

    public void addTextureName(String name) {
        this.textureNameList.add(name);
    }

    public WeaponSet getOrCreateWeaponSet(String type) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (type.compareTo(this.lastWeaponType) != 0 || this.lastWeaponIndex < 0) {
            this.weaponSetList.add(new WeaponSet(this, type));
            this.lastWeaponIndex = this.weaponSetList.size() - 1;
            this.lastWeaponType = type;
        }
        return this.weaponSetList.get(this.lastWeaponIndex);
    }

    public PartWeapon getLastWeaponPart() {
        return this.lastWeaponPart;
    }

    public void setLastWeaponPart(PartWeapon part) {
        this.lastWeaponPart = part;
    }

    public int getWeaponCount() {
        return this.weaponSetList.size();
    }

    public CrawlerTrack createCrawlerTrack(String data, String name) {
        int i;
        String[] s = this.splitParam(data);
        int PC = s.length - 3;
        boolean REV = this.toBool(s[0]);
        float LEN = this.toFloat(s[1], 0.001f, 1000.0f) * 0.9f;
        float Z = this.toFloat(s[2]);
        if (PC < 4) {
            return null;
        }
        double[] cx = new double[PC];
        double[] cy = new double[PC];
        for (int i2 = 0; i2 < PC; ++i2) {
            int idx = !REV ? i2 : PC - i2 - 1;
            String[] xy = this.splitParamSlash(s[3 + idx]);
            cx[i2] = this.toFloat(xy[0]);
            cy[i2] = this.toFloat(xy[1]);
        }
        ArrayList<CrawlerTrackPrm> lp = new ArrayList<CrawlerTrackPrm>();
        lp.add(new CrawlerTrackPrm(this, (float)cx[0], (float)cy[0]));
        double dist = 0.0;
        for (i = 0; i < PC; ++i) {
            double x = cx[(i + 1) % PC] - cx[i];
            double y = cy[(i + 1) % PC] - cy[i];
            double dist2 = dist += Math.sqrt(x * x + y * y);
            int j = 1;
            while (dist >= (double)LEN) {
                lp.add(new CrawlerTrackPrm(this, (float)(cx[i] + x * ((double)(LEN * (float)j) / dist2)), (float)(cy[i] + y * ((double)(LEN * (float)j) / dist2))));
                dist -= (double)LEN;
                ++j;
            }
        }
        for (i = 0; i < lp.size(); ++i) {
            float ppr;
            CrawlerTrackPrm pp = (CrawlerTrackPrm)lp.get((i + lp.size() - 1) % lp.size());
            CrawlerTrackPrm cp = (CrawlerTrackPrm)lp.get(i);
            CrawlerTrackPrm np = (CrawlerTrackPrm)lp.get((i + 1) % lp.size());
            float pr = (float)(Math.atan2(pp.x - cp.x, pp.y - cp.y) * 180.0 / Math.PI);
            float nr = (float)(Math.atan2(np.x - cp.x, np.y - cp.y) * 180.0 / Math.PI);
            float nnr = nr + 180.0f;
            if (((double)nnr < (double)(ppr = (pr + 360.0f) % 360.0f) - 0.3 || (double)nnr > (double)ppr + 0.3) && nnr - ppr < 100.0f && nnr - ppr > -100.0f) {
                nnr = (nnr + ppr) / 2.0f;
            }
            cp.r = nnr;
        }
        CrawlerTrack c = new CrawlerTrack(this, name);
        c.len = LEN;
        c.cx = cx;
        c.cy = cy;
        c.lp = lp;
        c.z = Z;
        c.side = Z >= 0.0f ? 1 : 0;
        return c;
    }

    public String getTextureName() {
        String s = this.textureNameList.get(this.textureCount);
        this.textureCount = (this.textureCount + 1) % this.textureNameList.size();
        return s;
    }

    public String getNextTextureName(String base) {
        if (this.textureNameList.size() >= 2) {
            for (int i = 0; i < this.textureNameList.size(); ++i) {
                String s = this.textureNameList.get(i);
                if (!s.equalsIgnoreCase(base)) continue;
                i = (i + 1) % this.textureNameList.size();
                return this.textureNameList.get(i);
            }
        }
        return base;
    }

    @Override
    public boolean canReloadItem(String item) {
        String[] ignoreItems;
        for (String s : ignoreItems = MCH_AircraftInfo.getCannotReloadItem()) {
            if (!s.equalsIgnoreCase(item)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MCH_AircraftInfo.jvmdowngrader$concat$toString$1(MCH_AircraftInfo.jvmdowngrader$concat$toString$1(this.name, String.valueOf(this.recipe), String.valueOf(this.weaponSetList), String.valueOf(this.seatList), String.valueOf(this.exclusionSeatList), String.valueOf(this.hudList), String.valueOf(this.extraBoundingBox), String.valueOf(this.wheels), String.valueOf(this.entityRackList), String.valueOf(this.mobDropOption), String.valueOf(this.repellingHooks), String.valueOf(this.rideRacks), String.valueOf(this.particleSplashs), String.valueOf(this.searchLights), String.valueOf(this.cameraPosition), String.valueOf(this.hatchList), String.valueOf(this.cameraList), String.valueOf(this.partWeapon), String.valueOf(this.partWeaponBay), String.valueOf(this.canopyList), String.valueOf(this.landingGear), String.valueOf(this.partThrottle), String.valueOf(this.partRotPart), String.valueOf(this.partCrawlerTrack), String.valueOf(this.partTrackRoller), String.valueOf(this.partWheel), String.valueOf(this.partSteeringWheel), String.valueOf(this.lightHatchList), String.valueOf(this.textureNameList), String.valueOf(this.flare), this.displayName, String.valueOf(this.displayNameLang), this.itemID, String.valueOf(this.recipeString), this.isShapedRecipe, this.category, this.creativeOnly, this.invulnerable, this.isEnableGunnerMode, this.cameraZoom, this.isEnableConcurrentGunnerMode, this.isEnableNightVision, this.isEnableEntityRadar, this.isEnableEjectionSeat, this.isEnableParachuting, this.bodyHeight, this.bodyWidth, this.isFloat, this.floatOffset, this.gravity, this.gravityInWater, this.maxHp, this.armorMinDamage, this.armorMaxDamage, this.armorDamageFactor, this.enableBack, this.inventorySize, this.isUAV, this.isSmallUAV, this.isNewUAV, this.isTargetDrone, this.autoPilotRot, this.onGroundPitch, this.canMoveOnGround, this.canRotOnGround, String.valueOf(this.hudTvMissile), this.damageFactor, this.submergedDamageHeight, this.regeneration, this.maxFuel, this.fuelConsumption, this.fuelSupplyRange, this.ammoSupplyRange, this.repairOtherVehiclesRange, this.repairOtherVehiclesValue, this.stealth, this.canRide, this.entityWidth, this.entityHeight, this.entityPitch, this.entityRoll, this.stepHeight, this.mobSeatNum, this.entityRackNum, this.rotorSpeed, this.enableSeaSurfaceParticle, this.pivotTurnThrottle, this.trackRollerRot, this.partWheelRot, this.onGroundPitchFactor, this.onGroundRollFactor, String.valueOf(this.turretPosition), this.defaultFreelook, String.valueOf(this.unmountPosition), this.thirdPersonDist, this.markerWidth, this.markerHeight, this.bbZmin), MCH_AircraftInfo.jvmdowngrader$concat$toString$1(this.bbZmax, this.bbZ, this.alwaysCameraView, this.cameraRotationSpeed, this.speed, this.motionFactor, this.mobilityYaw, this.mobilityPitch, this.mobilityRoll, this.mobilityYawOnGround, this.minRotationPitch, this.maxRotationPitch, this.minRotationRoll, this.maxRotationRoll, this.limitRotation, this.throttleUpDown, this.throttleUpDownOnEntity, this.textureCount, this.particlesScale, this.hideEntity, this.smoothShading, String.valueOf(this.soundMove), this.soundRange, this.soundVolume, this.soundPitch, String.valueOf(this.model), this.nameOnModernAARadar, this.nameOnEarlyAARadar, this.nameOnModernASRadar, this.nameOnEarlyASRadar, this.explosionSizeByCrash, this.throttleDownFactor, this.chaffUseTime, this.chaffWaitTime, this.maintenanceUseTime, this.maintenanceWaitTime, this.engineShutdownThreshold, this.apsUseTime, this.apsWaitTime, this.apsRange, this.oneProbeScale, this.lastWeaponType, this.lastWeaponIndex, String.valueOf(this.lastWeaponPart)));
    }

    @Override
    public void onPostReload() {
        this.hudCache = null;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20, String string21, String string22, String string23, String string24, String string25, String string26, String string27, String string28, String string29, String string30, String string31, String string32, int n, String string33, boolean bl, String string34, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, float f, float f2, boolean bl10, float f3, float f4, float f5, int n3, float f6, float f7, float f8, boolean bl11, int n4, boolean bl12, boolean bl13, boolean bl14, boolean bl15, float f9, float f10, boolean bl16, boolean bl17, String string35, float f11, float f12, boolean bl18, int n5, float f13, float f14, float f15, float f16, int n6, float f17, boolean bl19, float f18, float f19, float f20, float f21, float f22, int n7, int n8, float f23, boolean bl20, float f24, float f25, float f26, float f27, float f28, String string36, boolean bl21, String string37, float f29, float f30, float f31, float f32) {
        return "MCH_AircraftInfo{name='" + string + "', recipe=" + string2 + ", weaponSetList=" + string3 + ", seatList=" + string4 + ", exclusionSeatList=" + string5 + ", hudList=" + string6 + ", extraBoundingBox=" + string7 + ", wheels=" + string8 + ", entityRackList=" + string9 + ", mobDropOption=" + string10 + ", repellingHooks=" + string11 + ", rideRacks=" + string12 + ", particleSplashs=" + string13 + ", searchLights=" + string14 + ", cameraPosition=" + string15 + ", hatchList=" + string16 + ", cameraList=" + string17 + ", partWeapon=" + string18 + ", partWeaponBay=" + string19 + ", canopyList=" + string20 + ", landingGear=" + string21 + ", partThrottle=" + string22 + ", partRotPart=" + string23 + ", partCrawlerTrack=" + string24 + ", partTrackRoller=" + string25 + ", partWheel=" + string26 + ", partSteeringWheel=" + string27 + ", lightHatchList=" + string28 + ", textureNameList=" + string29 + ", flare=" + string30 + ", displayName='" + string31 + "', displayNameLang=" + string32 + ", itemID=" + n + ", recipeString=" + string33 + ", isShapedRecipe=" + bl + ", category='" + string34 + "', creativeOnly=" + bl2 + ", invulnerable=" + bl3 + ", isEnableGunnerMode=" + bl4 + ", cameraZoom=" + n2 + ", isEnableConcurrentGunnerMode=" + bl5 + ", isEnableNightVision=" + bl6 + ", isEnableEntityRadar=" + bl7 + ", isEnableEjectionSeat=" + bl8 + ", isEnableParachuting=" + bl9 + ", bodyHeight=" + f + ", bodyWidth=" + f2 + ", isFloat=" + bl10 + ", floatOffset=" + f3 + ", gravity=" + f4 + ", gravityInWater=" + f5 + ", maxHp=" + n3 + ", armorMinDamage=" + f6 + ", armorMaxDamage=" + f7 + ", armorDamageFactor=" + f8 + ", enableBack=" + bl11 + ", inventorySize=" + n4 + ", isUAV=" + bl12 + ", isSmallUAV=" + bl13 + ", isNewUAV=" + bl14 + ", isTargetDrone=" + bl15 + ", autoPilotRot=" + f9 + ", onGroundPitch=" + f10 + ", canMoveOnGround=" + bl16 + ", canRotOnGround=" + bl17 + ", hudTvMissile=" + string35 + ", damageFactor=" + f11 + ", submergedDamageHeight=" + f12 + ", regeneration=" + bl18 + ", maxFuel=" + n5 + ", fuelConsumption=" + f13 + ", fuelSupplyRange=" + f14 + ", ammoSupplyRange=" + f15 + ", repairOtherVehiclesRange=" + f16 + ", repairOtherVehiclesValue=" + n6 + ", stealth=" + f17 + ", canRide=" + bl19 + ", entityWidth=" + f18 + ", entityHeight=" + f19 + ", entityPitch=" + f20 + ", entityRoll=" + f21 + ", stepHeight=" + f22 + ", mobSeatNum=" + n7 + ", entityRackNum=" + n8 + ", rotorSpeed=" + f23 + ", enableSeaSurfaceParticle=" + bl20 + ", pivotTurnThrottle=" + f24 + ", trackRollerRot=" + f25 + ", partWheelRot=" + f26 + ", onGroundPitchFactor=" + f27 + ", onGroundRollFactor=" + f28 + ", turretPosition=" + string36 + ", defaultFreelook=" + bl21 + ", unmountPosition=" + string37 + ", thirdPersonDist=" + f29 + ", markerWidth=" + f30 + ", markerHeight=" + f31 + ", bbZmin=" + f32;
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, float f2, boolean bl, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, boolean bl2, float f14, float f15, int n, float f16, boolean bl3, boolean bl4, String string, float f17, float f18, float f19, String string2, String string3, String string4, String string5, String string6, float f20, float f21, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, float f22, String string7, int n10, String string8) {
        return ", bbZmax=" + f + ", bbZ=" + f2 + ", alwaysCameraView=" + bl + ", cameraRotationSpeed=" + f3 + ", speed=" + f4 + ", motionFactor=" + f5 + ", mobilityYaw=" + f6 + ", mobilityPitch=" + f7 + ", mobilityRoll=" + f8 + ", mobilityYawOnGround=" + f9 + ", minRotationPitch=" + f10 + ", maxRotationPitch=" + f11 + ", minRotationRoll=" + f12 + ", maxRotationRoll=" + f13 + ", limitRotation=" + bl2 + ", throttleUpDown=" + f14 + ", throttleUpDownOnEntity=" + f15 + ", textureCount=" + n + ", particlesScale=" + f16 + ", hideEntity=" + bl3 + ", smoothShading=" + bl4 + ", soundMove='" + string + "', soundRange=" + f17 + ", soundVolume=" + f18 + ", soundPitch=" + f19 + ", model=" + string2 + ", nameOnModernAARadar='" + string3 + "', nameOnEarlyAARadar='" + string4 + "', nameOnModernASRadar='" + string5 + "', nameOnEarlyASRadar='" + string6 + "', explosionSizeByCrash=" + f20 + ", throttleDownFactor=" + f21 + ", chaffUseTime=" + n2 + ", chaffWaitTime=" + n3 + ", maintenanceUseTime=" + n4 + ", maintenanceWaitTime=" + n5 + ", engineShutdownThreshold=" + n6 + ", apsUseTime=" + n7 + ", apsWaitTime=" + n8 + ", apsRange=" + n9 + ", oneProbeScale=" + f22 + ", lastWeaponType='" + string7 + "', lastWeaponIndex=" + n10 + ", lastWeaponPart=" + string8 + "}";
    }

    private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
        return string + string2;
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Flare {
        public Vec3d pos = new Vec3d(0.0, 0.0, 0.0);
        public int[] types = new int[0];

        public Flare(MCH_AircraftInfo paramMCH_AircraftInfo) {
        }

        public String toString() {
            return Flare.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), Arrays.toString(this.types));
        }

        @Generated
        public Flare(Vec3d pos, int[] types) {
            this.pos = pos;
            this.types = types;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
            return "Flare{pos=" + string + ", types=" + string2 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class PartWeapon
    extends DrawnPart {
        public final String[] name;
        public final boolean rotBarrel;
        public final boolean isMissile;
        public final boolean hideGM;
        public final boolean yaw;
        public final boolean pitch;
        public final float recoilBuf;
        public final boolean turret;
        public final List<PartWeaponChild> child;

        public PartWeapon(MCH_AircraftInfo paramMCH_AircraftInfo, String[] name, boolean rotBrl, boolean missile, boolean hgm, boolean y, boolean p, float px, float py, float pz, String modelName, float rx, float ry, float rz, float rb, boolean turret) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, modelName);
            this.name = name;
            this.rotBarrel = rotBrl;
            this.isMissile = missile;
            this.hideGM = hgm;
            this.yaw = y;
            this.pitch = p;
            this.recoilBuf = rb;
            this.child = new ArrayList<PartWeaponChild>();
            this.turret = turret;
        }

        public PartWeapon(DrawnPart other, String[] name, boolean rotBarrel, boolean isMissile, boolean hideGM, boolean yaw, boolean pitch, float recoilBuf, boolean turret) {
            super(other);
            this.name = name;
            this.rotBarrel = rotBarrel;
            this.isMissile = isMissile;
            this.hideGM = hideGM;
            this.yaw = yaw;
            this.pitch = pitch;
            this.recoilBuf = recoilBuf;
            this.turret = turret;
            this.child = new ArrayList<PartWeaponChild>();
        }

        @Override
        public String toString() {
            return PartWeapon.jvmdowngrader$concat$toString$1(Arrays.toString(this.name), this.rotBarrel, this.isMissile, this.hideGM, this.yaw, this.pitch, this.recoilBuf, this.turret, String.valueOf(this.child), String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, float f, boolean bl6, String string2, String string3, String string4, String string5, String string6) {
            return "PartWeapon{name=" + string + ", rotBarrel=" + bl + ", isMissile=" + bl2 + ", hideGM=" + bl3 + ", yaw=" + bl4 + ", pitch=" + bl5 + ", recoilBuf=" + f + ", turret=" + bl6 + ", child=" + string2 + ", pos=" + string3 + ", rot=" + string4 + ", modelName='" + string5 + "', model=" + string6 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class CameraPosition {
        public final Vec3d pos;
        public final boolean fixRot;
        public final float yaw;
        public final float pitch;

        public CameraPosition(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d vec3, boolean fixRot, float yaw, float pitch) {
            this.pos = vec3.func_72441_c(0.0, (double)0.35f, 0.0);
            this.fixRot = fixRot;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public CameraPosition(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d vec3) {
            this(paramMCH_AircraftInfo, vec3, false, 0.0f, 0.0f);
        }

        public CameraPosition(MCH_AircraftInfo paramMCH_AircraftInfo) {
            this(paramMCH_AircraftInfo, new Vec3d(0.0, 0.0, 0.0));
        }

        public CameraPosition(Vec3d pos, boolean fixRot, float yaw, float pitch) {
            this.pos = pos.func_72441_c(0.0, (double)0.35f, 0.0);
            this.fixRot = fixRot;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public String toString() {
            return CameraPosition.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.fixRot, this.yaw, this.pitch);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, float f, float f2) {
            return "CameraPosition{pos=" + string + ", fixRot=" + bl + ", yaw=" + f + ", pitch=" + f2 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class WeaponBay
    extends DrawnPart {
        public final float maxRotFactor;
        public final boolean isSlide;
        public final String weaponName;
        public Integer[] weaponIds;

        public WeaponBay(MCH_AircraftInfo paramMCH_AircraftInfo, String wn, float px, float py, float pz, float rx, float ry, float rz, float mr, String name, boolean slide) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.maxRotFactor = mr;
            this.isSlide = slide;
            this.weaponName = wn;
            this.weaponIds = new Integer[0];
        }

        public WeaponBay(DrawnPart other, float maxRotFactor, boolean isSlide, String weaponName) {
            super(other);
            this.maxRotFactor = maxRotFactor;
            this.isSlide = isSlide;
            this.weaponName = weaponName;
            this.weaponIds = new Integer[0];
        }

        @Override
        public String toString() {
            return WeaponBay.jvmdowngrader$concat$toString$1(this.maxRotFactor, this.isSlide, this.weaponName, Arrays.toString((Object[])this.weaponIds), String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, boolean bl, String string, String string2, String string3, String string4, String string5, String string6) {
            return "WeaponBay{maxRotFactor=" + f + ", isSlide=" + bl + ", weaponName='" + string + "', weaponIds=" + string2 + ", pos=" + string3 + ", rot=" + string4 + ", modelName='" + string5 + "', model=" + string6 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class WeaponSet {
        public final String type;
        public final ArrayList<Weapon> weapons;

        public WeaponSet(String t) {
            this.type = t;
            this.weapons = new ArrayList();
        }

        public WeaponSet(MCH_AircraftInfo paramMCH_AircraftInfo, String t) {
            this.type = t;
            this.weapons = new ArrayList();
        }

        public String toString() {
            return WeaponSet.jvmdowngrader$concat$toString$1(this.type, String.valueOf(this.weapons));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2) {
            return "WeaponSet{type='" + string + "', weapons=" + string2 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Weapon {
        public final Vec3d pos;
        public final float yaw;
        public final float pitch;
        public final boolean canUsePilot;
        public final int seatID;
        public final float defaultYaw;
        public final float minYaw;
        public final float maxYaw;
        public final float minPitch;
        public final float maxPitch;
        public final boolean turret;

        public Weapon(MCH_AircraftInfo paramMCH_AircraftInfo, float x, float y, float z, float yaw, float pitch, boolean canPirot, int seatId, float defy, float mny, float mxy, float mnp, float mxp, boolean turret) {
            this.pos = new Vec3d((double)x, (double)(y + 0.35f), (double)z);
            this.yaw = yaw;
            this.pitch = pitch;
            this.canUsePilot = canPirot;
            this.seatID = seatId;
            this.defaultYaw = defy;
            this.minYaw = mny;
            this.maxYaw = mxy;
            this.minPitch = mnp;
            this.maxPitch = mxp;
            this.turret = turret;
        }

        public Weapon(float x, float y, float z, float yaw, float pitch, boolean canPirot, int seatId, float defy, float mny, float mxy, float mnp, float mxp, boolean turret) {
            this.pos = new Vec3d((double)x, (double)(y + 0.35f), (double)z);
            this.yaw = yaw;
            this.pitch = pitch;
            this.canUsePilot = canPirot;
            this.seatID = seatId;
            this.defaultYaw = defy;
            this.minYaw = mny;
            this.maxYaw = mxy;
            this.minPitch = mnp;
            this.maxPitch = mxp;
            this.turret = turret;
        }

        public String toString() {
            return Weapon.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.yaw, this.pitch, this.canUsePilot, this.seatID, this.defaultYaw, this.minYaw, this.maxYaw, this.minPitch, this.maxPitch, this.turret);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, float f, float f2, boolean bl, int n, float f3, float f4, float f5, float f6, float f7, boolean bl2) {
            return "Weapon{pos=" + string + ", yaw=" + f + ", pitch=" + f2 + ", canUsePilot=" + bl + ", seatID=" + n + ", defaultYaw=" + f3 + ", minYaw=" + f4 + ", maxYaw=" + f5 + ", minPitch=" + f6 + ", maxPitch=" + f7 + ", turret=" + bl2 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class CrawlerTrackPrm {
        public final float x;
        public final float y;
        public float nx;
        public float ny;
        public float r;

        public CrawlerTrackPrm(MCH_AircraftInfo paramMCH_AircraftInfo, float x, float y) {
            this.x = x;
            this.y = y;
        }

        public CrawlerTrackPrm(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return CrawlerTrackPrm.jvmdowngrader$concat$toString$1(this.x, this.y, this.nx, this.ny, this.r);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, float f2, float f3, float f4, float f5) {
            return "CrawlerTrackPrm{x=" + f + ", y=" + f2 + ", nx=" + f3 + ", ny=" + f4 + ", r=" + f5 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class CrawlerTrack
    extends DrawnPart {
        public float len = 0.35f;
        public double[] cx;
        public double[] cy;
        public List<CrawlerTrackPrm> lp;
        public float z;
        public int side;

        public CrawlerTrack(MCH_AircraftInfo paramMCH_AircraftInfo, String name) {
            super(paramMCH_AircraftInfo, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, name);
        }

        public CrawlerTrack(String name) {
            super(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, name);
        }

        @Override
        public String toString() {
            return CrawlerTrack.jvmdowngrader$concat$toString$1(this.len, Arrays.toString(this.cx), Arrays.toString(this.cy), String.valueOf(this.lp), this.z, this.side, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, String string, String string2, String string3, float f2, int n, String string4, String string5, String string6, String string7) {
            return "CrawlerTrack{len=" + f + ", cx=" + string + ", cy=" + string2 + ", lp=" + string3 + ", z=" + f2 + ", side=" + n + ", pos=" + string4 + ", rot=" + string5 + ", modelName='" + string6 + "', model=" + string7 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Wheel {
        public final Vec3d pos;
        public final float size;

        public Wheel(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d v, float sz) {
            this.pos = v;
            this.size = sz;
        }

        public Wheel(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d v) {
            this(paramMCH_AircraftInfo, v, 1.0f);
        }

        public String toString() {
            return Wheel.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.size);
        }

        @Generated
        public Wheel(Vec3d pos, float size) {
            this.pos = pos;
            this.size = size;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, float f) {
            return "Wheel{pos=" + string + ", size=" + f + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class TrackRoller
    extends DrawnPart {
        final int side;

        public TrackRoller(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, String name) {
            super(paramMCH_AircraftInfo, px, py, pz, 0.0f, 0.0f, 0.0f, name);
            this.side = px >= 0.0f ? 1 : 0;
        }

        public TrackRoller(DrawnPart other) {
            super(other);
            this.side = other.pos.field_72450_a >= 0.0 ? 1 : 0;
        }

        @Override
        public String toString() {
            return TrackRoller.jvmdowngrader$concat$toString$1(this.side, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(int n, String string, String string2, String string3, String string4) {
            return "TrackRoller{side=" + n + ", pos=" + string + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Throttle
    extends DrawnPart {
        public final Vec3d slide;
        public final float rot2;

        public Throttle(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float rot, String name, float px2, float py2, float pz2) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.rot2 = rot;
            this.slide = new Vec3d((double)px2, (double)py2, (double)pz2);
        }

        public Throttle(DrawnPart other, Vec3d slide, float rot2) {
            super(other);
            this.slide = slide;
            this.rot2 = rot2;
        }

        @Override
        public String toString() {
            return Throttle.jvmdowngrader$concat$toString$1(String.valueOf(this.slide), this.rot2, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, float f, String string2, String string3, String string4, String string5) {
            return "Throttle{slide=" + string + ", rot2=" + f + ", pos=" + string2 + ", rot=" + string3 + ", modelName='" + string4 + "', model=" + string5 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class SearchLight {
        public final Vec3d pos;
        public final int colorStart;
        public final int colorEnd;
        public final float height;
        public final float width;
        public final float angle;
        public final boolean fixDir;
        public final float yaw;
        public final float pitch;
        public final boolean steering;
        public final float stRot;

        public SearchLight(Vec3d pos, int cs, int ce, float h, float w, boolean fix, float y, float p, boolean st, float stRot) {
            this.colorStart = cs;
            this.colorEnd = ce;
            this.pos = pos;
            this.height = h;
            this.width = w;
            this.angle = (float)(Math.atan2(w / 2.0f, h) * 180.0 / Math.PI);
            this.fixDir = fix;
            this.steering = st;
            this.yaw = y;
            this.pitch = p;
            this.stRot = stRot;
        }

        public SearchLight(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d pos, int cs, int ce, float h, float w, boolean fix, float y, float p, boolean st, float stRot) {
            this.colorStart = cs;
            this.colorEnd = ce;
            this.pos = pos;
            this.height = h;
            this.width = w;
            this.angle = (float)(Math.atan2(w / 2.0f, h) * 180.0 / Math.PI);
            this.fixDir = fix;
            this.steering = st;
            this.yaw = y;
            this.pitch = p;
            this.stRot = stRot;
        }

        public String toString() {
            return SearchLight.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.colorStart, this.colorEnd, this.height, this.width, this.angle, this.fixDir, this.yaw, this.pitch, this.steering, this.stRot);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, int n, int n2, float f, float f2, float f3, boolean bl, float f4, float f5, boolean bl2, float f6) {
            return "SearchLight{pos=" + string + ", colorStart=" + n + ", colorEnd=" + n2 + ", height=" + f + ", width=" + f2 + ", angle=" + f3 + ", fixDir=" + bl + ", yaw=" + f4 + ", pitch=" + f5 + ", steering=" + bl2 + ", stRot=" + f6 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class RotPart
    extends DrawnPart {
        public final float rotSpeed;
        public final boolean rotAlways;

        public RotPart(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float mr, boolean a, String name) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.rotSpeed = mr;
            this.rotAlways = a;
        }

        public RotPart(DrawnPart other, float rotSpeed, boolean rotAlways) {
            super(other);
            this.rotSpeed = rotSpeed;
            this.rotAlways = rotAlways;
        }

        @Override
        public String toString() {
            return RotPart.jvmdowngrader$concat$toString$1(this.rotSpeed, this.rotAlways, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, boolean bl, String string, String string2, String string3, String string4) {
            return "RotPart{rotSpeed=" + f + ", rotAlways=" + bl + ", pos=" + string + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class RideRack {
        public final String name;
        public final int rackID;

        public RideRack(MCH_AircraftInfo paramMCH_AircraftInfo, String n, int id) {
            this.name = n;
            this.rackID = id;
        }

        public String toString() {
            return RideRack.jvmdowngrader$concat$toString$1(this.name, this.rackID);
        }

        @Generated
        public RideRack(String name, int rackID) {
            this.name = name;
            this.rackID = rackID;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, int n) {
            return "RideRack{name='" + string + "', rackID=" + n + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class RepellingHook {
        public final Vec3d pos;
        public final int interval;

        public RepellingHook(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d pos, int inv) {
            this.pos = pos;
            this.interval = inv;
        }

        public String toString() {
            return RepellingHook.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.interval);
        }

        @Generated
        public RepellingHook(Vec3d pos, int interval) {
            this.pos = pos;
            this.interval = interval;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, int n) {
            return "RepellingHook{pos=" + string + ", interval=" + n + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class ParticleSplash {
        public final int num;
        public final float acceleration;
        public final float size;
        public final Vec3d pos;
        public final int age;
        public final float motionY;
        public final float gravity;

        public ParticleSplash(MCH_AircraftInfo paramMCH_AircraftInfo, Vec3d v, int nm, float siz, float acc, int ag, float my, float gr) {
            this.num = nm;
            this.pos = v;
            this.size = siz;
            this.acceleration = acc;
            this.age = ag;
            this.motionY = my;
            this.gravity = gr;
        }

        public String toString() {
            return ParticleSplash.jvmdowngrader$concat$toString$1(this.num, this.acceleration, this.size, String.valueOf(this.pos), this.age, this.motionY, this.gravity);
        }

        @Generated
        public ParticleSplash(int num, float acceleration, float size, Vec3d pos, int age, float motionY, float gravity) {
            this.num = num;
            this.acceleration = acceleration;
            this.size = size;
            this.pos = pos;
            this.age = age;
            this.motionY = motionY;
            this.gravity = gravity;
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(int n, float f, float f2, String string, int n2, float f3, float f4) {
            return "ParticleSplash{num=" + n + ", acceleration=" + f + ", size=" + f2 + ", pos=" + string + ", age=" + n2 + ", motionY=" + f3 + ", gravity=" + f4 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class PartWheel
    extends DrawnPart {
        public final float rotDir;
        public final Vec3d pos2;

        public PartWheel(DrawnPart other, float rotDir, Vec3d pos2) {
            super(other);
            this.rotDir = rotDir;
            this.pos2 = pos2;
        }

        public PartWheel(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float rd, float px2, float py2, float pz2, String name) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.rotDir = rd;
            this.pos2 = new Vec3d((double)px2, (double)py2, (double)pz2);
        }

        public PartWheel(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float rd, String name) {
            this(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, rd, px, py, pz, name);
        }

        @Override
        public String toString() {
            return PartWheel.jvmdowngrader$concat$toString$1(this.rotDir, String.valueOf(this.pos2), String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, String string, String string2, String string3, String string4, String string5) {
            return "PartWheel{rotDir=" + f + ", pos2=" + string + ", pos=" + string2 + ", rot=" + string3 + ", modelName='" + string4 + "', model=" + string5 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class PartWeaponChild
    extends DrawnPart {
        public final String[] name;
        public final boolean yaw;
        public final boolean pitch;
        public final float recoilBuf;

        public PartWeaponChild(MCH_AircraftInfo paramMCH_AircraftInfo, String[] name, boolean y, boolean p, float px, float py, float pz, String modelName, float rx, float ry, float rz, float rb) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, modelName);
            this.name = name;
            this.yaw = y;
            this.pitch = p;
            this.recoilBuf = rb;
        }

        public PartWeaponChild(Vec3d pos, Vec3d rot, String modelName, String[] name, boolean yaw, boolean pitch, float recoilBuf) {
            super(pos, rot, modelName);
            this.name = name;
            this.yaw = yaw;
            this.pitch = pitch;
            this.recoilBuf = recoilBuf;
        }

        @Override
        public String toString() {
            return PartWeaponChild.jvmdowngrader$concat$toString$1(Arrays.toString(this.name), this.yaw, this.pitch, this.recoilBuf, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, boolean bl2, float f, String string2, String string3, String string4, String string5) {
            return "PartWeaponChild{name=" + string + ", yaw=" + bl + ", pitch=" + bl2 + ", recoilBuf=" + f + ", pos=" + string2 + ", rot=" + string3 + ", modelName='" + string4 + "', model=" + string5 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class LandingGear
    extends DrawnPart {
        public final float maxRotFactor;
        public final boolean reverse;
        public final boolean hatch;
        public Vec3d slide = null;
        public boolean enableRot2;
        public Vec3d rot2;
        public float maxRotFactor2;

        public LandingGear(DrawnPart other, float maxRotFactor, boolean reverse, boolean hatch) {
            super(other);
            this.maxRotFactor = maxRotFactor;
            this.reverse = reverse;
            this.hatch = hatch;
        }

        public LandingGear(MCH_AircraftInfo paramMCH_AircraftInfo, float x, float y, float z, float rx, float ry, float rz, String model, float maxRotF, boolean rev, boolean isHatch) {
            super(paramMCH_AircraftInfo, x, y, z, rx, ry, rz, model);
            this.maxRotFactor = maxRotF;
            this.enableRot2 = false;
            this.rot2 = new Vec3d(0.0, 0.0, 0.0);
            this.maxRotFactor2 = 0.0f;
            this.reverse = rev;
            this.hatch = isHatch;
        }

        @Override
        public String toString() {
            return LandingGear.jvmdowngrader$concat$toString$1(this.maxRotFactor, this.reverse, this.hatch, String.valueOf(this.slide), this.enableRot2, String.valueOf(this.rot2), this.maxRotFactor2, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, boolean bl, boolean bl2, String string, boolean bl3, String string2, float f2, String string3, String string4, String string5, String string6) {
            return "LandingGear{maxRotFactor=" + f + ", reverse=" + bl + ", hatch=" + bl2 + ", slide=" + string + ", enableRot2=" + bl3 + ", rot2=" + string2 + ", maxRotFactor2=" + f2 + ", pos=" + string3 + ", rot=" + string4 + ", modelName='" + string5 + "', model=" + string6 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Hatch
    extends DrawnPart {
        public final float maxRotFactor;
        public final float maxRot;
        public final boolean isSlide;

        public Hatch(Vec3d pos, Vec3d rot, String modelName, float maxRot, boolean isSlide) {
            super(pos, rot, modelName);
            this.maxRot = maxRot;
            this.maxRotFactor = this.maxRot / 90.0f;
            this.isSlide = isSlide;
        }

        public Hatch(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float mr, String name, boolean slide) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.maxRot = mr;
            this.maxRotFactor = this.maxRot / 90.0f;
            this.isSlide = slide;
        }

        public Hatch(DrawnPart base, float maxRot, boolean isSlide) {
            super(base);
            this.maxRot = maxRot;
            this.maxRotFactor = maxRot / 90.0f;
            this.isSlide = isSlide;
        }

        @Override
        public String toString() {
            return Hatch.jvmdowngrader$concat$toString$1(this.maxRotFactor, this.maxRot, this.isSlide, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, float f2, boolean bl, String string, String string2, String string3, String string4) {
            return "Hatch{maxRotFactor=" + f + ", maxRot=" + f2 + ", isSlide=" + bl + ", pos=" + string + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class DrawnPart {
        public final Vec3d pos;
        public final Vec3d rot;
        public final String modelName;
        public _IModelCustom model;

        public DrawnPart(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, String name) {
            this.pos = new Vec3d((double)px, (double)py, (double)pz);
            this.rot = new Vec3d((double)rx, (double)ry, (double)rz);
            this.modelName = name;
            this.model = null;
        }

        public DrawnPart(Vec3d pos, Vec3d rot, String modelName) {
            this.pos = pos;
            this.rot = rot;
            this.modelName = modelName;
        }

        public DrawnPart(DrawnPart other) {
            this.pos = other.pos;
            this.rot = other.rot;
            this.modelName = other.modelName;
            this.model = other.model;
        }

        public String toString() {
            return DrawnPart.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        @Generated
        protected DrawnPart(DrawnPartBuilder<?, ?> b) {
            this.pos = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$pos();
            this.rot = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$rot();
            this.modelName = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$modelName();
            this.model = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$model();
        }

        @Generated
        public static DrawnPartBuilder<?, ?> builder() {
            return new DrawnPartBuilderImpl();
        }

        @Generated
        public DrawnPartBuilder<?, ?> toBuilder() {
            return new DrawnPartBuilderImpl().$fillValuesFrom(this);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
            return "DrawnPart{pos=" + string + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }

        @NestHost(value=MCH_AircraftInfo.class)
        @Generated
        public static abstract class DrawnPartBuilder<C extends DrawnPart, B extends DrawnPartBuilder<C, B>> {
            @Generated
            private Vec3d pos;
            @Generated
            private Vec3d rot;
            @Generated
            private String modelName;
            @Generated
            private _IModelCustom model;

            @Generated
            protected B $fillValuesFrom(C instance) {
                DrawnPartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(DrawnPart instance, DrawnPartBuilder<?, ?> b) {
                b.pos(instance.pos);
                b.rot(instance.rot);
                b.modelName(instance.modelName);
                b.model(instance.model);
            }

            @Generated
            public B pos(Vec3d pos) {
                this.pos = pos;
                return this.self();
            }

            @Generated
            public B rot(Vec3d rot) {
                this.rot = rot;
                return this.self();
            }

            @Generated
            public B modelName(String modelName) {
                this.modelName = modelName;
                return this.self();
            }

            @Generated
            public B model(_IModelCustom model) {
                this.model = model;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return DrawnPartBuilder.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
            }

            public /* synthetic */ String jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$modelName() {
                return this.modelName;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$set$modelName(String string) {
                this.modelName = string;
            }

            public /* synthetic */ _IModelCustom jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$model() {
                return this.model;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$set$model(_IModelCustom _IModelCustom2) {
                this.model = _IModelCustom2;
            }

            public /* synthetic */ Vec3d jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$pos() {
                return this.pos;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$set$pos(Vec3d vec3d) {
                this.pos = vec3d;
            }

            public /* synthetic */ Vec3d jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$get$rot() {
                return this.rot;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$DrawnPart$DrawnPartBuilder$set$rot(Vec3d vec3d) {
                this.rot = vec3d;
            }

            private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, String string2, String string3, String string4) {
                return "MCH_AircraftInfo.DrawnPart.DrawnPartBuilder(pos=" + string + ", rot=" + string2 + ", modelName=" + string3 + ", model=" + string4 + ")";
            }
        }

        @NestHost(value=MCH_AircraftInfo.class)
        @Generated
        private static final class DrawnPartBuilderImpl
        extends DrawnPartBuilder<DrawnPart, DrawnPartBuilderImpl> {
            @Generated
            DrawnPartBuilderImpl() {
            }

            @Override
            @Generated
            protected DrawnPartBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DrawnPart build() {
                return new DrawnPart(this);
            }
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Canopy
    extends DrawnPart {
        public final float maxRotFactor;
        public final boolean isSlide;

        public Canopy(DrawnPart base, float maxRotationFactor, boolean isSlide) {
            super(base);
            this.maxRotFactor = maxRotationFactor;
            this.isSlide = isSlide;
        }

        public Canopy(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, float mr, String name, boolean slide) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.maxRotFactor = mr;
            this.isSlide = slide;
        }

        @Override
        public String toString() {
            return Canopy.jvmdowngrader$concat$toString$1(this.maxRotFactor, this.isSlide, String.valueOf(this.pos), String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(float f, boolean bl, String string, String string2, String string3, String string4) {
            return "Canopy{maxRotFactor=" + f + ", isSlide=" + bl + ", pos=" + string + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }
    }

    @NestHost(value=MCH_AircraftInfo.class)
    public static class Camera
    extends DrawnPart {
        public final boolean yawSync;
        public final boolean pitchSync;

        public Camera(MCH_AircraftInfo paramMCH_AircraftInfo, float px, float py, float pz, float rx, float ry, float rz, String name, boolean ys, boolean ps) {
            super(paramMCH_AircraftInfo, px, py, pz, rx, ry, rz, name);
            this.yawSync = ys;
            this.pitchSync = ps;
        }

        public Camera(DrawnPart base, boolean yawSync, boolean pitchSync) {
            super(base);
            this.yawSync = yawSync;
            this.pitchSync = pitchSync;
        }

        @Override
        public String toString() {
            return Camera.jvmdowngrader$concat$toString$1(String.valueOf(this.pos), this.yawSync, this.pitchSync, String.valueOf(this.rot), this.modelName, String.valueOf(this.model));
        }

        @Generated
        protected Camera(CameraBuilder<?, ?> b) {
            super(b);
            this.yawSync = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$get$yawSync();
            this.pitchSync = b.jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$get$pitchSync();
        }

        @Generated
        public static CameraBuilder<?, ?> builder() {
            return new CameraBuilderImpl();
        }

        @Generated
        public CameraBuilder<?, ?> toBuilder() {
            return new CameraBuilderImpl().$fillValuesFrom(this);
        }

        private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, boolean bl2, String string2, String string3, String string4) {
            return "Camera{pos=" + string + ", yawSync=" + bl + ", pitchSync=" + bl2 + ", rot=" + string2 + ", modelName='" + string3 + "', model=" + string4 + "}";
        }

        @NestHost(value=MCH_AircraftInfo.class)
        @Generated
        public static abstract class CameraBuilder<C extends Camera, B extends CameraBuilder<C, B>>
        extends DrawnPart.DrawnPartBuilder<C, B> {
            @Generated
            private boolean yawSync;
            @Generated
            private boolean pitchSync;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                CameraBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Camera instance, CameraBuilder<?, ?> b) {
                b.yawSync(instance.yawSync);
                b.pitchSync(instance.pitchSync);
            }

            @Generated
            public B yawSync(boolean yawSync) {
                this.yawSync = yawSync;
                return (B)this.self();
            }

            @Generated
            public B pitchSync(boolean pitchSync) {
                this.pitchSync = pitchSync;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return CameraBuilder.jvmdowngrader$concat$toString$1(super.toString(), this.yawSync, this.pitchSync);
            }

            public /* synthetic */ boolean jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$get$pitchSync() {
                return this.pitchSync;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$set$pitchSync(boolean bl) {
                this.pitchSync = bl;
            }

            public /* synthetic */ boolean jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$get$yawSync() {
                return this.yawSync;
            }

            public /* synthetic */ void jvmdowngrader$nest$com_norwood_mcheli_aircraft_MCH_AircraftInfo$Camera$CameraBuilder$set$yawSync(boolean bl) {
                this.yawSync = bl;
            }

            private static /* synthetic */ String jvmdowngrader$concat$toString$1(String string, boolean bl, boolean bl2) {
                return "MCH_AircraftInfo.Camera.CameraBuilder(super=" + string + ", yawSync=" + bl + ", pitchSync=" + bl2 + ")";
            }
        }

        @NestHost(value=MCH_AircraftInfo.class)
        @Generated
        private static final class CameraBuilderImpl
        extends CameraBuilder<Camera, CameraBuilderImpl> {
            @Generated
            CameraBuilderImpl() {
            }

            @Override
            @Generated
            protected CameraBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Camera build() {
                return new Camera(this);
            }
        }
    }
}

