/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.aircraft;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_KeyName;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.gui.MCH_Gui;
import com.norwood.mcheli.hud.MCH_Hud;
import com.norwood.mcheli.weapon.MCH_EntityTvMissile;
import com.norwood.mcheli.weapon.MCH_WeaponSet;
import com.norwood.mcheli.wrapper.W_McClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public abstract class MCH_AircraftCommonGui
extends MCH_Gui {
    public MCH_AircraftCommonGui(Minecraft minecraft) {
        super(minecraft);
    }

    public void drawHud(MCH_EntityAircraft aircraft, EntityPlayer player, int seatId) {
        MCH_Hud hud;
        MCH_AircraftInfo info = aircraft.getAcInfo();
        if (info == null) {
            return;
        }
        if (aircraft.isMissileCameraMode((Entity)player) && aircraft.getTVMissile() != null && info.hudTvMissile != null) {
            info.hudTvMissile.draw(aircraft, player, this.smoothCamPartialTicks);
            return;
        }
        if (seatId >= 0 && seatId < info.hudList.size() && (hud = info.hudList.get(seatId)) != null) {
            hud.draw(aircraft, player, this.smoothCamPartialTicks);
        }
    }

    public void drawDebugtInfo(MCH_EntityAircraft ac) {
        if (MCH_Config.DebugLog) {
            // empty if block
        }
    }

    public void drawNightVisionNoise() {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
        GlStateManager.func_179112_b((int)1, (int)1);
        W_McClient.MOD_bindTexture("textures/gui/alpha.png");
        this.drawTexturedModalRectRotate(0.0, 0.0, this.field_146294_l, this.field_146295_m, this.rand.nextInt(256), this.rand.nextInt(256), 256.0, 256.0, 0.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
    }

    public void drawHitMarker(int hitStrength, int maxHitStrength, int baseColor) {
        if (hitStrength <= 0) {
            return;
        }
        int centerX = this.centerX;
        int centerY = this.centerY;
        int outerOffset = 10;
        int innerOffset = 5;
        double[] markerLines = new double[]{centerX - 10, centerY - 10, centerX - 5, centerY - 5, centerX - 10, centerY + 10, centerX - 5, centerY + 5, centerX + 10, centerY - 10, centerX + 5, centerY - 5, centerX + 10, centerY + 10, centerX + 5, centerY + 5};
        int alpha = hitStrength * (256 / maxHitStrength);
        int finalColor = (int)(MCH_Config.hitMarkColorAlpha * (float)alpha) << 24 | MCH_Config.hitMarkColorRGB;
        this.drawLine(markerLines, finalColor);
    }

    public void drawHitMarker(MCH_EntityAircraft ac, int color, int seatID) {
        this.drawHitMarker(ac.getHitStatus(), ac.getMaxHitStatus(), color);
    }

    protected void drawTvMissileNoise(MCH_EntityAircraft ac, MCH_EntityTvMissile tvmissile) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)0.4f);
        GlStateManager.func_179112_b((int)1, (int)1);
        W_McClient.MOD_bindTexture("textures/gui/noise.png");
        this.drawTexturedModalRectRotate(0.0, 0.0, this.field_146294_l, this.field_146295_m, this.rand.nextInt(256), this.rand.nextInt(256), 256.0, 256.0, 0.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
    }

    public void drawKeyBind(MCH_EntityAircraft aircraft, MCH_AircraftInfo info, EntityPlayer player, int seatID, int rightX, int leftX, int colorActive, int colorInactive) {
        if (seatID == 0) {
            this.drawConditionalKeyBind(aircraft.canPutToRack(), "PutRack", MCH_Config.KeyPutToRack.prmInt, leftX, -10, colorActive);
            this.drawConditionalKeyBind(aircraft.canDownFromRack(), "DownRack", MCH_Config.KeyDownFromRack.prmInt, leftX, 0, colorActive);
            this.drawConditionalKeyBind(aircraft.canRideRack(), "RideRack", MCH_Config.KeyPutToRack.prmInt, leftX, 10, colorActive);
            this.drawConditionalKeyBind(aircraft.func_184187_bx() != null, "DismountRack", MCH_Config.KeyDownFromRack.prmInt, leftX, 10, colorActive);
        }
        boolean multipleSeats = aircraft.getSeatNum() > 1;
        boolean freeLookPressed = Keyboard.isKeyDown((int)MCH_Config.KeyFreeLook.prmInt);
        if (seatID > 0 && multipleSeats || freeLookPressed) {
            int seatColor = seatID == 0 ? 65328 : colorActive;
            String prefix = seatID == 0 ? MCH_AircraftCommonGui.jvmdowngrader$concat$drawKeyBind$1(MCH_KeyName.getDescOrName(MCH_Config.KeyFreeLook.prmInt)) : "";
            this.drawString(MCH_AircraftCommonGui.jvmdowngrader$concat$drawKeyBind$1(prefix, MCH_KeyName.getDescOrName(MCH_Config.KeyGUI.prmInt)), rightX, this.centerY - 70, seatColor);
            this.drawString(MCH_AircraftCommonGui.jvmdowngrader$concat$drawKeyBind$2(prefix, MCH_KeyName.getDescOrName(MCH_Config.KeyExtra.prmInt)), rightX, this.centerY - 60, seatColor);
        }
        this.drawString(MCH_AircraftCommonGui.jvmdowngrader$concat$drawKeyBind$1(aircraft.getGunnerStatus() ? "ON" : "OFF", MCH_KeyName.getDescOrName(MCH_Config.KeyFreeLook.prmInt), MCH_KeyName.getDescOrName(MCH_Config.KeyCameraMode.prmInt)), leftX, this.centerY - 40, colorActive);
        if (seatID >= 0 && seatID <= 1 && aircraft.haveFlare()) {
            int flareColor = aircraft.isFlarePreparation() ? colorInactive : colorActive;
            this.drawString(MCH_AircraftCommonGui.jvmdowngrader$concat$drawKeyBind$2(MCH_KeyName.getDescOrName(MCH_Config.KeyFlare.prmInt)), rightX, this.centerY - 50, flareColor);
        }
        if (seatID == 0 && info.haveLandingGear()) {
            if (aircraft.canFoldLandingGear()) {
                this.drawConditionalKeyBind(true, "Gear Up", MCH_Config.KeyGearUpDown.prmInt, rightX, -40, colorActive);
            } else if (aircraft.canUnfoldLandingGear()) {
                this.drawConditionalKeyBind(true, "Gear Down", MCH_Config.KeyGearUpDown.prmInt, rightX, -40, colorActive);
            }
        }
        MCH_WeaponSet weaponSet = aircraft.getCurrentWeapon((Entity)player);
        if (aircraft.getWeaponNum() > 1) {
            this.drawConditionalKeyBind(true, "Weapon", MCH_Config.KeySwitchWeapon2.prmInt, leftX, -70, colorActive);
        }
        if (weaponSet.getCurrentWeapon().numMode > 0) {
            this.drawConditionalKeyBind(true, "WeaponMode", MCH_Config.KeySwWeaponMode.prmInt, leftX, -60, colorActive);
        }
        if (aircraft.canSwitchSearchLight((Entity)player)) {
            this.drawConditionalKeyBind(true, "SearchLight", MCH_Config.KeyCameraMode.prmInt, leftX, -50, colorActive);
        } else if (aircraft.canSwitchCameraMode(seatID)) {
            this.drawConditionalKeyBind(true, "CameraMode", MCH_Config.KeyCameraMode.prmInt, leftX, -50, colorActive);
        }
        if (seatID == 0 && aircraft.getSeatNum() >= 1) {
            int dismountColor = colorActive;
            String dismountLabel = "Dismount";
            if (info.isEnableParachuting && MCH_Lib.getBlockIdY(aircraft, 3, -10) == 0) {
                dismountLabel = "Parachuting";
            } else if (aircraft.canStartRepelling()) {
                dismountLabel = "Repelling";
                dismountColor = 65280;
            }
            this.drawConditionalKeyBind(true, dismountLabel, MCH_Config.KeyUnmount.prmInt, leftX, -30, dismountColor);
        }
        boolean canFreeLook = seatID == 0 && aircraft.canSwitchFreeLook() || seatID > 0 && aircraft.canSwitchGunnerModeOtherSeat(player);
        this.drawConditionalKeyBind(canFreeLook, "FreeLook", MCH_Config.KeyFreeLook.prmInt, leftX, -20, colorActive);
    }

    private void drawConditionalKeyBind(boolean condition, String label, int key, int x, int yOffset, int color) {
        if (condition) {
            String keyName = MCH_KeyName.getDescOrName(key);
            this.drawString(MCH_AircraftCommonGui.jvmdowngrader$concat$drawConditionalKeyBind$1(label, keyName), x, this.centerY + yOffset, color);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$1(String string) {
        return string + " + ";
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$1(String string, String string2) {
        return "NextSeat : " + string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$2(String string, String string2) {
        return "PrevSeat : " + string + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$1(String string, String string2, String string3) {
        return "Gunner " + string + " : " + string2 + " + " + string3;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawKeyBind$2(String string) {
        return "Flare : " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$drawConditionalKeyBind$1(String string, String string2) {
        return string + " : " + string2;
    }
}

