/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli.aircraft;

import com.norwood.mcheli.aircraft.MCH_BoundingBox;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

public class MCH_AircraftBoundingBox
extends AxisAlignedBB {
    private final MCH_EntityAircraft ac;

    protected MCH_AircraftBoundingBox(MCH_EntityAircraft ac) {
        this(ac, ac.func_174813_aQ());
    }

    public MCH_AircraftBoundingBox(MCH_EntityAircraft ac, AxisAlignedBB aabb) {
        super(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        this.ac = ac;
    }

    public AxisAlignedBB NewAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new MCH_AircraftBoundingBox(this.ac, new AxisAlignedBB(x1, y1, z1, x2, y2, z2));
    }

    public double getDistanceSquareBetween(AxisAlignedBB box1, AxisAlignedBB box2) {
        double centerX1 = (box1.field_72340_a + box1.field_72336_d) / 2.0;
        double centerY1 = (box1.field_72338_b + box1.field_72337_e) / 2.0;
        double centerZ1 = (box1.field_72339_c + box1.field_72334_f) / 2.0;
        double centerX2 = (box2.field_72340_a + box2.field_72336_d) / 2.0;
        double centerY2 = (box2.field_72338_b + box2.field_72337_e) / 2.0;
        double centerZ2 = (box2.field_72339_c + box2.field_72334_f) / 2.0;
        double dx = centerX1 - centerX2;
        double dy = centerY1 - centerY2;
        double dz = centerZ1 - centerZ2;
        return dx * dx + dy * dy + dz * dz;
    }

    public boolean func_72326_a(@NotNull AxisAlignedBB aabb) {
        boolean ret = false;
        double dist = 1.0E7;
        this.ac.lastBBDamageFactor = 1.0f;
        this.ac.lastBBName = null;
        if (super.func_72326_a(aabb)) {
            dist = this.getDistanceSquareBetween(aabb, this);
            ret = true;
        }
        for (MCH_BoundingBox bb : this.ac.extraBoundingBox) {
            if (!bb.boundingBox.func_72326_a(aabb) || !bb.intersectsAABB(aabb)) continue;
            double dist2 = this.getDistanceSquareBetween(aabb, this);
            if (dist2 < dist) {
                dist = dist2;
                this.ac.lastBBDamageFactor = bb.damageFactor;
                this.ac.lastBBName = bb.name;
            }
            ret = true;
        }
        return ret;
    }

    @NotNull
    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        double newMinX = this.field_72340_a - x;
        double newMinY = this.field_72338_b - y;
        double newMinZ = this.field_72339_c - z;
        double newMaxX = this.field_72336_d + x;
        double newMaxY = this.field_72337_e + y;
        double newMaxZ = this.field_72334_f + z;
        return this.NewAABB(newMinX, newMinY, newMinZ, newMaxX, newMaxY, newMaxZ);
    }

    @NotNull
    public AxisAlignedBB func_111270_a(AxisAlignedBB other) {
        double d0 = Math.min(this.field_72340_a, other.field_72340_a);
        double d1 = Math.min(this.field_72338_b, other.field_72338_b);
        double d2 = Math.min(this.field_72339_c, other.field_72339_c);
        double d3 = Math.max(this.field_72336_d, other.field_72336_d);
        double d4 = Math.max(this.field_72337_e, other.field_72337_e);
        double d5 = Math.max(this.field_72334_f, other.field_72334_f);
        return this.NewAABB(d0, d1, d2, d3, d4, d5);
    }

    @NotNull
    public AxisAlignedBB func_72321_a(double x, double y, double z) {
        double minX = this.field_72340_a + Math.min(0.0, x);
        double maxX = this.field_72336_d + Math.max(0.0, x);
        double minY = this.field_72338_b + Math.min(0.0, y);
        double maxY = this.field_72337_e + Math.max(0.0, y);
        double minZ = this.field_72339_c + Math.min(0.0, z);
        double maxZ = this.field_72334_f + Math.max(0.0, z);
        return this.NewAABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @NotNull
    public AxisAlignedBB func_191195_a(double x, double y, double z) {
        double d3 = this.field_72340_a + x;
        double d4 = this.field_72338_b + y;
        double d5 = this.field_72339_c + z;
        double d6 = this.field_72336_d - x;
        double d7 = this.field_72337_e - y;
        double d8 = this.field_72334_f - z;
        return this.NewAABB(d3, d4, d5, d6, d7, d8);
    }

    public AxisAlignedBB copy() {
        return this.NewAABB(this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, this.field_72337_e, this.field_72334_f);
    }

    public AxisAlignedBB getOffsetBoundingBox(double x, double y, double z) {
        return this.NewAABB(this.field_72340_a + x, this.field_72338_b + y, this.field_72339_c + z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z);
    }

    public RayTraceResult func_72327_a(Vec3d start, Vec3d end) {
        this.ac.lastBBDamageFactor = 1.0f;
        this.ac.lastBBName = null;
        RayTraceResult bestResult = super.func_72327_a(start, end);
        double bestDist = bestResult != null ? start.func_72438_d(bestResult.field_72307_f) : Double.MAX_VALUE;
        for (MCH_BoundingBox bb : this.ac.extraBoundingBox) {
            double tHit;
            Vec3d hit;
            double dist;
            double tmp;
            double t2;
            double t1;
            Vec3d dir = end.func_178788_d(start);
            double dirX = dir.func_72430_b(bb.axisX);
            double dirY = dir.func_72430_b(bb.axisY);
            double dirZ = dir.func_72430_b(bb.axisZ);
            Vec3d relStart = start.func_178788_d(bb.center);
            double startX = relStart.func_72430_b(bb.axisX);
            double startY = relStart.func_72430_b(bb.axisY);
            double startZ = relStart.func_72430_b(bb.axisZ);
            double tMin = 0.0;
            double tMax = 1.0;
            boolean skip = false;
            if (Math.abs(dirX) > 1.0E-7) {
                double invDx = 1.0 / dirX;
                t1 = ((double)(-bb.halfWidth) - startX) * invDx;
                t2 = ((double)bb.halfWidth - startX) * invDx;
                if (t1 > t2) {
                    tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                tMin = Math.max(tMin, t1);
                tMax = Math.min(tMax, t2);
            } else if (Math.abs(startX) > (double)bb.halfWidth + 1.0E-6) {
                skip = true;
            }
            if (!skip) {
                if (Math.abs(dirY) > 1.0E-7) {
                    double invDy = 1.0 / dirY;
                    t1 = ((double)(-bb.halfHeight) - startY) * invDy;
                    t2 = ((double)bb.halfHeight - startY) * invDy;
                    if (t1 > t2) {
                        tmp = t1;
                        t1 = t2;
                        t2 = tmp;
                    }
                    tMin = Math.max(tMin, t1);
                    tMax = Math.min(tMax, t2);
                } else if (Math.abs(startY) > (double)bb.halfHeight + 1.0E-6) {
                    skip = true;
                }
            }
            if (!skip) {
                if (Math.abs(dirZ) > 1.0E-7) {
                    double invDz = 1.0 / dirZ;
                    t1 = ((double)(-bb.halfDepth) - startZ) * invDz;
                    t2 = ((double)bb.halfDepth - startZ) * invDz;
                    if (t1 > t2) {
                        tmp = t1;
                        t1 = t2;
                        t2 = tmp;
                    }
                    tMin = Math.max(tMin, t1);
                    tMax = Math.min(tMax, t2);
                } else if (Math.abs(startZ) > (double)bb.halfDepth + 1.0E-6) {
                    skip = true;
                }
            }
            if (skip || !(tMax >= tMin) || !(tMin <= 1.0) || !(tMax >= 0.0) || !((dist = start.func_72438_d(hit = start.func_178787_e(dir.func_186678_a(tHit = tMin < 0.0 ? tMax : tMin)))) < bestDist)) continue;
            bestDist = dist;
            Vec3d hitVec = new Vec3d(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c);
            bestResult = new RayTraceResult(hitVec, EnumFacing.DOWN, new BlockPos(hitVec));
            this.ac.lastBBDamageFactor = bb.damageFactor;
            this.ac.lastBBName = bb.name;
        }
        return bestResult;
    }
}

