/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli;

import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.client.MCH_Models;
import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.wrapper.W_ModelBase;
import com.norwood.mcheli.wrapper.modelloader.ModelVBO;
import com.norwood.mcheli.wrapper.modelloader.W_ModelCustom;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public class MCH_ModelManager
extends W_ModelBase {
    private static final MCH_ModelManager instance = new MCH_ModelManager();
    private static final ConcurrentHashMap<String, _IModelCustom> map = new ConcurrentHashMap();
    private static final ModelRenderer defaultModel;
    private static boolean forceReloadMode;

    private MCH_ModelManager() {
    }

    public static void makeVBO() {
        map.forEach((k, v) -> {
            if (v != null) {
                v.toVBO();
            }
        });
    }

    public static void setForceReloadMode(boolean b) {
        forceReloadMode = b;
    }

    public static _IModelCustom load(@NotNull String path, @NotNull String name, boolean noThrow) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(name);
        if (path.isEmpty() || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return MCH_ModelManager.load(MCH_ModelManager.jvmdowngrader$concat$load$1(path, name), noThrow);
    }

    public static _IModelCustom load(@NotNull String path, @NotNull String name) {
        return MCH_ModelManager.load(path, name, false);
    }

    @Nullable
    public static _IModelCustom load(String name, boolean noThrow) {
        _IModelCustom model;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        _IModelCustom obj = map.get(name);
        if (obj != null) {
            if (!forceReloadMode) {
                return obj;
            }
            if (obj instanceof ModelVBO) {
                ((ModelVBO)obj).delete();
            }
            map.remove(name);
        }
        try {
            model = MCH_Models.loadModel(name);
        }
        catch (MCH_Models.ModelLoadException mle) {
            if (!noThrow) {
                MCH_Utils.logger().catching((Throwable)mle);
            }
            model = null;
        }
        if (model != null) {
            map.put(name, model);
        }
        return model;
    }

    public static _IModelCustom load(String name) {
        return MCH_ModelManager.load(name, false);
    }

    public static void render(String path, String name) {
        MCH_ModelManager.render(MCH_ModelManager.jvmdowngrader$concat$load$1(path, name));
    }

    public static void render(String name) {
        _IModelCustom model = map.get(name);
        if (model != null) {
            model.renderAll();
        } else if (defaultModel == null) {
            // empty if block
        }
    }

    public static void renderPart(String name, String partName) {
        _IModelCustom model = map.get(name);
        if (model != null) {
            model.renderPart(partName);
        }
    }

    public static void render(String path, String name, int startFace, int maxFace) {
        _IModelCustom model = map.get(MCH_ModelManager.jvmdowngrader$concat$load$1(path, name));
        if (model instanceof W_ModelCustom) {
            ((W_ModelCustom)model).renderAll(startFace, maxFace);
        }
    }

    public static W_ModelCustom get(String path, String name) {
        _IModelCustom model = map.get(MCH_ModelManager.jvmdowngrader$concat$load$1(path, name));
        return model instanceof W_ModelCustom ? (W_ModelCustom)model : null;
    }

    static {
        forceReloadMode = false;
        defaultModel = new ModelRenderer((ModelBase)instance, 0, 0);
        defaultModel.func_78790_a(-5.0f, -5.0f, -5.0f, 10, 10, 10, 0.0f);
    }

    private static /* synthetic */ String jvmdowngrader$concat$load$1(String string, String string2) {
        return string + "/" + string2;
    }
}

