/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli;

import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_EntitySeat;
import com.norwood.mcheli.aircraft.MCH_ItemAircraft;
import com.norwood.mcheli.chain.MCH_ItemChain;
import com.norwood.mcheli.command.MCH_Command;
import com.norwood.mcheli.networking.packet.PacketSyncServerSettings;
import com.norwood.mcheli.weapon.MCH_EntityBaseBullet;
import com.norwood.mcheli.wrapper.W_Entity;
import com.norwood.mcheli.wrapper.W_EntityPlayer;
import com.norwood.mcheli.wrapper.W_EventHook;
import com.norwood.mcheli.wrapper.W_Lib;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MCH_EventHook
extends W_EventHook {
    @Override
    public void commandEvent(CommandEvent event) {
        MCH_Command.onCommandEvent(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        MCH_MOD.proxy.registerParticleTextures(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPost(TextureStitchEvent.Post event) {
        MCH_MOD.proxy.registerShaders(event);
    }

    @Override
    public void entitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (W_Lib.isEntityLivingBase(entity) && !W_EntityPlayer.isPlayer(entity)) {
            MCH_MOD.proxy.setRenderEntityDistanceWeight(MCH_Config.MobRenderDistanceWeight.prmDouble);
            return;
        }
        if (entity instanceof MCH_EntityAircraft) {
            MCH_EntityAircraft aircraft = (MCH_EntityAircraft)entity;
            if (!aircraft.field_70170_p.field_72995_K && !aircraft.isCreatedSeats()) {
                aircraft.createSeats(UUID.randomUUID().toString());
            }
            return;
        }
        if (W_EntityPlayer.isPlayer(entity)) {
            this.correctInvalidRotation(entity);
            if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayerMP) {
                MCH_Lib.DbgLog(false, MCH_EventHook.jvmdowngrader$concat$entitySpawn$1(String.valueOf(entity)), new Object[0]);
                PacketSyncServerSettings.send((EntityPlayerMP)entity);
            }
        }
    }

    private void correctInvalidRotation(Entity e) {
        boolean invalidYaw;
        boolean invalidPitch;
        boolean bl = invalidPitch = Float.isNaN(e.field_70125_A) || Float.isNaN(e.field_70127_C) || Float.isInfinite(e.field_70125_A) || Float.isInfinite(e.field_70127_C);
        if (invalidPitch) {
            MCH_Lib.Log(e, MCH_EventHook.jvmdowngrader$concat$correctInvalidRotation$1(e.field_70125_A), new Object[0]);
            e.field_70125_A = 0.0f;
            e.field_70127_C = 0.0f;
        }
        boolean bl2 = invalidYaw = Float.isNaN(e.field_70177_z) || Float.isNaN(e.field_70126_B) || Float.isInfinite(e.field_70177_z) || Float.isInfinite(e.field_70126_B);
        if (invalidYaw) {
            MCH_Lib.Log(e, MCH_EventHook.jvmdowngrader$concat$correctInvalidRotation$2(e.field_70177_z), new Object[0]);
            e.field_70177_z = 0.0f;
            e.field_70126_B = 0.0f;
        }
    }

    @Override
    public void livingAttackEvent(LivingAttackEvent event) {
        MCH_EntityAircraft ac = this.getRiddenAircraft(event.getEntity());
        if (ac != null && ac.getAcInfo() != null && !ac.isDestroyed() && !(ac.getAcInfo().damageFactor > 0.0f)) {
            Entity attackEntity = event.getSource().func_76346_g();
            if (attackEntity == null) {
                event.setCanceled(true);
            } else if (W_Entity.isEqual(attackEntity, event.getEntity())) {
                event.setCanceled(true);
            } else if (ac.isMountedEntity(attackEntity)) {
                event.setCanceled(true);
            } else {
                MCH_EntityAircraft atkac = this.getRiddenAircraft(attackEntity);
                if (W_Entity.isEqual(atkac, ac)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public void livingHurtEvent(LivingHurtEvent event) {
        Entity entity = event.getEntity();
        MCH_EntityAircraft aircraft = this.getRiddenAircraft(entity);
        if (aircraft == null || aircraft.isDestroyed() || aircraft.getAcInfo() == null) {
            return;
        }
        Entity attacker = event.getSource().func_76346_g();
        float damage = event.getAmount();
        float factor = aircraft.getAcInfo().damageFactor;
        boolean selfDamage = attacker == null || W_Entity.isEqual(attacker, entity);
        boolean isRiderAttacking = aircraft.isMountedEntity(attacker);
        boolean isSameAircraft = W_Entity.isEqual(this.getRiddenAircraft(attacker), aircraft);
        if (isRiderAttacking || isSameAircraft) {
            event.setCanceled(true);
            event.setAmount(0.0f);
            return;
        }
        aircraft.func_70097_a(event.getSource(), damage * 2.0f);
        event.setAmount(damage * factor);
    }

    public MCH_EntityAircraft getRiddenAircraft(Entity entity) {
        if (entity == null) {
            return null;
        }
        MCH_EntityAircraft ac = null;
        Entity ridden = entity.func_184187_bx();
        if (ridden == null) {
            return null;
        }
        if (ridden instanceof MCH_EntityAircraft) {
            ac = (MCH_EntityAircraft)ridden;
        } else if (ridden instanceof MCH_EntitySeat) {
            ac = ((MCH_EntitySeat)ridden).getParent();
        }
        if (ac == null) {
            List list = entity.field_70170_p.func_72872_a(MCH_EntityAircraft.class, entity.func_174813_aQ().func_72314_b(50.0, 50.0, 50.0));
            for (MCH_EntityAircraft tmp : list) {
                if (!tmp.isMountedEntity(entity)) continue;
                return tmp;
            }
        }
        return ac;
    }

    @Override
    public void entityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        ItemStack item = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (!item.func_190926_b()) {
            if (item.func_77973_b() instanceof MCH_ItemChain) {
                MCH_ItemChain.interactEntity(item, event.getTarget(), event.getEntityPlayer(), event.getEntityPlayer().field_70170_p);
                event.setCanceled(true);
            } else if (item.func_77973_b() instanceof MCH_ItemAircraft) {
                ((MCH_ItemAircraft)item.func_77973_b()).rideEntity(item, event.getTarget(), event.getEntityPlayer());
            }
        }
    }

    @Override
    public void entityCanUpdate(EntityEvent.CanUpdate event) {
        Entity entity = event.getEntity();
        if (entity instanceof MCH_EntityBaseBullet) {
            MCH_EntityBaseBullet bullet = (MCH_EntityBaseBullet)entity;
            bullet.func_70106_y();
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$entitySpawn$1(String string) {
        return "EntityJoinWorldEvent: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$correctInvalidRotation$1(float f) {
        return "### EntityJoinWorldEvent Error: Player invalid rotation pitch (" + f + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$correctInvalidRotation$2(float f) {
        return "### EntityJoinWorldEvent Error: Player invalid rotation yaw (" + f + ")";
    }
}

