/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli;

import com.norwood.mcheli.EntityInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={ClientTicker.class, Tracked.class})
public class MCH_EntityInfoClientTracker {
    private static final Map<Integer, Tracked> tracked = new ConcurrentHashMap<Integer, Tracked>();
    public static long EXPIRATION_MS = 1000L;
    public static long MISSING_SEQ_THRESHOLD = 20L;
    public static int CLEANUP_TICK_INTERVAL = 10;
    private static volatile long lastAppliedSeq = -1L;
    private static volatile long latestSeqObserved = -1L;
    private static int clientTickCounter = 0;

    public static void updateEntities(List<EntityInfo> infos, long snapshotSeq) {
        if (snapshotSeq < lastAppliedSeq) {
            return;
        }
        long now = System.currentTimeMillis();
        latestSeqObserved = Math.max(latestSeqObserved, snapshotSeq);
        for (EntityInfo info : infos) {
            Tracked t = tracked.get(info.entityId);
            if (t == null) {
                tracked.put(info.entityId, new Tracked(info, now, snapshotSeq));
                continue;
            }
            t.info = info;
            t.lastSeenMillis = now;
            t.lastSeenSeq = snapshotSeq;
        }
        lastAppliedSeq = snapshotSeq;
    }

    public static EntityInfo getEntityInfo(int entityId) {
        Tracked t = tracked.get(entityId);
        return t == null ? null : t.info;
    }

    public static Collection<EntityInfo> getAllTrackedEntities() {
        ArrayList<EntityInfo> out = new ArrayList<EntityInfo>(tracked.size());
        for (Tracked t : tracked.values()) {
            out.add(t.info);
        }
        return Collections.unmodifiableCollection(out);
    }

    private static void cleanupExpired() {
        if (tracked.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long seqNow = latestSeqObserved;
        Iterator<Map.Entry<Integer, Tracked>> it = tracked.entrySet().iterator();
        while (it.hasNext()) {
            boolean seqExpired;
            Map.Entry<Integer, Tracked> e = it.next();
            Tracked t = e.getValue();
            boolean timeExpired = now - t.lastSeenMillis > EXPIRATION_MS;
            boolean bl = seqExpired = seqNow - t.lastSeenSeq > MISSING_SEQ_THRESHOLD;
            if (!timeExpired && !seqExpired) continue;
            it.remove();
        }
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)new ClientTicker());
    }

    @NestHost(value=MCH_EntityInfoClientTracker.class)
    private static final class Tracked {
        EntityInfo info;
        long lastSeenMillis;
        long lastSeenSeq;

        Tracked(EntityInfo info, long now, long seq) {
            this.info = info;
            this.lastSeenMillis = now;
            this.lastSeenSeq = seq;
        }
    }

    @NestHost(value=MCH_EntityInfoClientTracker.class)
    public static class ClientTicker {
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            clientTickCounter = clientTickCounter + 1;
            if (clientTickCounter % CLEANUP_TICK_INTERVAL == 0) {
                MCH_EntityInfoClientTracker.cleanupExpired();
            }
        }
    }
}

