/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli;

public class MCH_Color {
    public final float a;
    public final float r;
    public final float g;
    public final float b;

    public String toHexString() {
        int ia = Math.round(this.a * 255.0f);
        int ir = Math.round(this.r * 255.0f);
        int ig = Math.round(this.g * 255.0f);
        int ib = Math.round(this.b * 255.0f);
        return String.format("#%02X%02X%02X%02X", ia, ir, ig, ib);
    }

    public MCH_Color(float aa, float rr, float gg, float bb) {
        this.a = this.round(aa);
        this.r = this.round(rr);
        this.g = this.round(gg);
        this.b = this.round(bb);
    }

    public MCH_Color(int argb) {
        this.a = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.r = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.g = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.b = (float)(argb & 0xFF) / 255.0f;
    }

    public MCH_Color(float rr, float gg, float bb) {
        this(1.0f, rr, gg, bb);
    }

    public MCH_Color() {
        this(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public float round(float f) {
        return f > 1.0f ? 1.0f : Math.max(f, 0.0f);
    }
}

