/*
 * Decompiled with CFR 0.152.
 */
package com.norwood.mcheli;

import com.norwood.mcheli.MCH_ClientCommonTickHandler;
import com.norwood.mcheli.MCH_ClientEventHook;
import com.norwood.mcheli.MCH_CommonProxy;
import com.norwood.mcheli.MCH_Config;
import com.norwood.mcheli.MCH_Lib;
import com.norwood.mcheli.MCH_MOD;
import com.norwood.mcheli.MCH_ModelManager;
import com.norwood.mcheli.MCH_RenderNull;
import com.norwood.mcheli.MCH_ViewEntityDummy;
import com.norwood.mcheli.aircraft.MCH_AircraftInfo;
import com.norwood.mcheli.aircraft.MCH_EntityAircraft;
import com.norwood.mcheli.aircraft.MCH_EntityHide;
import com.norwood.mcheli.aircraft.MCH_EntitySeat;
import com.norwood.mcheli.aircraft.MCH_RenderAircraft;
import com.norwood.mcheli.aircraft.MCH_SoundUpdater;
import com.norwood.mcheli.block.MCH_DraftingTableRenderer;
import com.norwood.mcheli.block.MCH_DraftingTableTileEntity;
import com.norwood.mcheli.chain.MCH_EntityChain;
import com.norwood.mcheli.chain.MCH_RenderChain;
import com.norwood.mcheli.command.MCH_GuiTitle;
import com.norwood.mcheli.container.MCH_EntityContainer;
import com.norwood.mcheli.container.MCH_RenderContainer;
import com.norwood.mcheli.flare.MCH_EntityFlare;
import com.norwood.mcheli.flare.MCH_RenderFlare;
import com.norwood.mcheli.gltd.MCH_EntityGLTD;
import com.norwood.mcheli.gltd.MCH_RenderGLTD;
import com.norwood.mcheli.helicopter.MCH_EntityHeli;
import com.norwood.mcheli.helicopter.MCH_HeliInfo;
import com.norwood.mcheli.helicopter.MCH_RenderHeli;
import com.norwood.mcheli.helper.MCH_Utils;
import com.norwood.mcheli.helper.addon.AddonManager;
import com.norwood.mcheli.helper.addon.AddonPack;
import com.norwood.mcheli.helper.client.MCH_CameraManager;
import com.norwood.mcheli.helper.client.MCH_ItemModelRenderers;
import com.norwood.mcheli.helper.client._IModelCustom;
import com.norwood.mcheli.helper.client.model.LegacyModelLoader;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInDraftingTableItemRenderer;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInGLTDItemRenderer;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInInvisibleItemRenderer;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInLightWeaponItemRenderer;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInRangeFinderItemRenderer;
import com.norwood.mcheli.helper.client.renderer.item.BuiltInWrenchItemRenderer;
import com.norwood.mcheli.helper.debug.MCH_RenderTest;
import com.norwood.mcheli.helper.info.ContentRegistries;
import com.norwood.mcheli.helper.info.ShaderRegistry;
import com.norwood.mcheli.hud.direct_drawable.HudGPS;
import com.norwood.mcheli.hud.direct_drawable.HudMortarRadar;
import com.norwood.mcheli.hud.direct_drawable.HudRWR;
import com.norwood.mcheli.mob.MCH_EntityGunner;
import com.norwood.mcheli.mob.MCH_RenderGunner;
import com.norwood.mcheli.multiplay.MCH_MultiplayClient;
import com.norwood.mcheli.parachute.MCH_EntityParachute;
import com.norwood.mcheli.parachute.MCH_RenderParachute;
import com.norwood.mcheli.particles.MCH_EntityParticleExplode;
import com.norwood.mcheli.plane.MCH_EntityPlane;
import com.norwood.mcheli.plane.MCH_PlaneInfo;
import com.norwood.mcheli.plane.MCP_RenderPlane;
import com.norwood.mcheli.ship.MCH_EntityShip;
import com.norwood.mcheli.ship.MCH_RenderShip;
import com.norwood.mcheli.ship.MCH_ShipInfo;
import com.norwood.mcheli.sound.ClientSoundRegistry;
import com.norwood.mcheli.tank.MCH_EntityTank;
import com.norwood.mcheli.tank.MCH_RenderTank;
import com.norwood.mcheli.tank.MCH_TankInfo;
import com.norwood.mcheli.throwable.MCH_EntityThrowable;
import com.norwood.mcheli.throwable.MCH_RenderThrowable;
import com.norwood.mcheli.throwable.MCH_ThrowableInfo;
import com.norwood.mcheli.uav.MCH_EntityUavStation;
import com.norwood.mcheli.uav.MCH_RenderUavStation;
import com.norwood.mcheli.vehicle.MCH_EntityVehicle;
import com.norwood.mcheli.vehicle.MCH_RenderVehicle;
import com.norwood.mcheli.vehicle.MCH_VehicleInfo;
import com.norwood.mcheli.weapon.MCH_BulletModel;
import com.norwood.mcheli.weapon.MCH_DefaultBulletModels;
import com.norwood.mcheli.weapon.MCH_EntityA10;
import com.norwood.mcheli.weapon.MCH_EntityAAMissile;
import com.norwood.mcheli.weapon.MCH_EntityASMissile;
import com.norwood.mcheli.weapon.MCH_EntityATMissile;
import com.norwood.mcheli.weapon.MCH_EntityBomb;
import com.norwood.mcheli.weapon.MCH_EntityBullet;
import com.norwood.mcheli.weapon.MCH_EntityCartridge;
import com.norwood.mcheli.weapon.MCH_EntityDispensedItem;
import com.norwood.mcheli.weapon.MCH_EntityMarkerRocket;
import com.norwood.mcheli.weapon.MCH_EntityRocket;
import com.norwood.mcheli.weapon.MCH_EntityTorpedo;
import com.norwood.mcheli.weapon.MCH_EntityTvMissile;
import com.norwood.mcheli.weapon.MCH_RenderA10;
import com.norwood.mcheli.weapon.MCH_RenderAAMissile;
import com.norwood.mcheli.weapon.MCH_RenderASMissile;
import com.norwood.mcheli.weapon.MCH_RenderBomb;
import com.norwood.mcheli.weapon.MCH_RenderBullet;
import com.norwood.mcheli.weapon.MCH_RenderCartridge;
import com.norwood.mcheli.weapon.MCH_RenderNone;
import com.norwood.mcheli.weapon.MCH_RenderTvMissile;
import com.norwood.mcheli.weapon.MCH_WeaponInfo;
import com.norwood.mcheli.wrapper.GLStateManagerExt;
import com.norwood.mcheli.wrapper.W_Item;
import com.norwood.mcheli.wrapper.W_LanguageRegistry;
import com.norwood.mcheli.wrapper.W_Reflection;
import com.norwood.mcheli.wrapper.W_TickRegistry;
import com.norwood.mcheli.wrapper.modelloader.W_ModelCustom;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MCH_ClientProxy
extends MCH_CommonProxy {
    private static final MethodHandle splashThreadGetter;
    private static final MethodHandle splashEnabledGetter;
    private static final MethodHandle splashPauseHandle;
    private static final MethodHandle splashResumeHandle;

    public static void registerModels_Bullet() {
        for (MCH_WeaponInfo wi : ContentRegistries.weapon().values()) {
            _IModelCustom m;
            if (!wi.bulletModelName.isEmpty() && (m = MCH_ModelManager.load("bullets", wi.bulletModelName)) != null) {
                wi.bulletModel = new MCH_BulletModel(wi.bulletModelName, m);
            }
            if (!wi.bombletModelName.isEmpty() && (m = MCH_ModelManager.load("bullets", wi.bombletModelName)) != null) {
                wi.bombletModel = new MCH_BulletModel(wi.bombletModelName, m);
            }
            if (wi.cartridge == null || wi.cartridge.name.isEmpty()) continue;
            wi.cartridge.model = MCH_ModelManager.load("bullets", wi.cartridge.name);
            if (wi.cartridge.model != null) continue;
            wi.cartridge = null;
        }
    }

    private static void uploadModel(MCH_AircraftInfo info, String path) {
        info.model = MCH_ModelManager.load(path, info.name);
        CompletableFuture done = new CompletableFuture();
        Minecraft.func_71410_x().func_152344_a(() -> {
            info.model = info.model.toVBO();
            done.complete(null);
        });
    }

    private static void pauseSplash() {
        if (MCH_ClientProxy.splashNotTerminated()) {
            try {
                splashPauseHandle.invokeExact();
                MCH_Utils.logger().debug("[MCH_ClientProxy] successfully paused Splashscreen");
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private static void resumeSplash() {
        if (MCH_ClientProxy.splashNotTerminated()) {
            try {
                splashResumeHandle.invokeExact();
                MCH_Utils.logger().debug("[MCH_ClientProxy] successfully resumed Splashscreen");
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private static boolean splashNotTerminated() {
        Thread splashThread;
        try {
            boolean enabled = splashEnabledGetter.invokeExact();
            if (!enabled) {
                MCH_Utils.logger().debug("[MCH_ClientProxy] Splashscreen is currently disabled");
                return false;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            splashThread = splashThreadGetter.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return splashThread.getState() != Thread.State.TERMINATED;
    }

    @Override
    public void postInit(FMLPostInitializationEvent postEvent) {
        IReloadableResourceManager rm = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        rm.func_110542_a(resourceManager -> ClientSoundRegistry.INSTANCE.commitChanges(Minecraft.func_71410_x().func_147118_V()));
    }

    @Override
    public String getDataDir() {
        return Minecraft.func_71410_x().field_71412_D.getPath();
    }

    @Override
    public void registerRenderer() {
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntitySeat.class, MCH_RenderTest.factory(0.0f, 0.3125f, 0.0f, "seat"));
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityHeli.class, MCH_RenderHeli.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityPlane.class, MCP_RenderPlane.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityShip.class, MCH_RenderShip.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityTank.class, MCH_RenderTank.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityGLTD.class, MCH_RenderGLTD.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityChain.class, MCH_RenderChain.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityParachute.class, MCH_RenderParachute.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityContainer.class, MCH_RenderContainer.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityVehicle.class, MCH_RenderVehicle.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityUavStation.class, MCH_RenderUavStation.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityCartridge.class, MCH_RenderCartridge.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityHide.class, MCH_RenderNull.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_ViewEntityDummy.class, MCH_RenderNull.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityRocket.class, MCH_RenderBullet.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityTvMissile.class, MCH_RenderTvMissile.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityBullet.class, MCH_RenderBullet.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityA10.class, MCH_RenderA10.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityAAMissile.class, MCH_RenderAAMissile.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityASMissile.class, MCH_RenderASMissile.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityATMissile.class, MCH_RenderTvMissile.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityTorpedo.class, MCH_RenderBullet.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityBomb.class, MCH_RenderBomb.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityMarkerRocket.class, MCH_RenderBullet.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityDispensedItem.class, MCH_RenderNone.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityFlare.class, MCH_RenderFlare.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityThrowable.class, MCH_RenderThrowable.FACTORY);
        RenderingRegistry.registerEntityRenderingHandler(MCH_EntityGunner.class, MCH_RenderGunner.FACTORY);
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.itemJavelin, new BuiltInLightWeaponItemRenderer());
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.itemStinger, new BuiltInLightWeaponItemRenderer());
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.invisibleItem, new BuiltInInvisibleItemRenderer());
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.itemGLTD, new BuiltInGLTDItemRenderer());
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.itemWrench, new BuiltInWrenchItemRenderer());
        MCH_ItemModelRenderers.registerRenderer(MCH_MOD.itemRangeFinder, new BuiltInRangeFinderItemRenderer());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)LegacyModelLoader.INSTANCE);
    }

    @Override
    public void registerBlockRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(MCH_DraftingTableTileEntity.class, (TileEntitySpecialRenderer)new MCH_DraftingTableRenderer());
        MCH_ItemModelRenderers.registerRenderer(W_Item.getItemFromBlock((Block)MCH_MOD.blockDraftingTable), new BuiltInDraftingTableItemRenderer());
    }

    @Override
    public void registerModels() {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        MCH_ModelManager.setForceReloadMode(true);
        CompletableFuture<Void> miscFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            MCH_RenderAircraft.debugModel = MCH_ModelManager.load("box");
            MCH_ModelManager.load("a-10");
            MCH_RenderGLTD.model = MCH_ModelManager.load("gltd");
            MCH_ModelManager.load("chain");
            MCH_ModelManager.load("container");
            MCH_ModelManager.load("parachute1");
            MCH_ModelManager.load("parachute2");
            MCH_ModelManager.load("wrench");
            MCH_ModelManager.load("rangefinder");
            MCH_ModelManager.load("lweapons", "fim92");
            MCH_ModelManager.load("lweapons", "fgm148");
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$0$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> bulletFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            MCH_DefaultBulletModels.Bullet = this.loadBulletModel("bullet");
            MCH_DefaultBulletModels.AAMissile = this.loadBulletModel("aamissile");
            MCH_DefaultBulletModels.ATMissile = this.loadBulletModel("asmissile");
            MCH_DefaultBulletModels.ASMissile = this.loadBulletModel("asmissile");
            MCH_DefaultBulletModels.Bomb = this.loadBulletModel("bomb");
            MCH_DefaultBulletModels.Rocket = this.loadBulletModel("rocket");
            MCH_DefaultBulletModels.Torpedo = this.loadBulletModel("torpedo");
            MCH_ClientProxy.registerModels_Bullet();
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$1$3((end - start) / 1000000L));
        });
        CompletableFuture<Void> uavFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            for (String s : MCH_RenderUavStation.MODEL_NAME) {
                MCH_ModelManager.load(s);
            }
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$2$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> heliFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            ContentRegistries.heli().forEachValueParallel(info -> this.registerModelsHeli((MCH_HeliInfo)info, false));
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$3$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> planeFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            ContentRegistries.plane().forEachValueParallel(info -> this.registerModelsPlane((MCH_PlaneInfo)info, false));
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$5$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> shipFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            ContentRegistries.ship().forEachValueParallel(info -> this.registerModelsShip((MCH_ShipInfo)info, false));
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$7$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> tankFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            ContentRegistries.tank().forEachValueParallel(info -> this.registerModelsTank((MCH_TankInfo)info, false));
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$9$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> vehicleFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            ContentRegistries.vehicle().forEachValueParallel(info -> this.registerModelsVehicle((MCH_VehicleInfo)info, false));
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$11$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> throwableFuture = CompletableFuture.runAsync(() -> {
            long start = System.nanoTime();
            for (MCH_ThrowableInfo wi : ContentRegistries.throwable().values()) {
                wi.model = MCH_ModelManager.load("throwable", wi.name);
            }
            long end = System.nanoTime();
            System.out.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$13$1((end - start) / 1000000L));
        });
        CompletableFuture<Void> allTasks = CompletableFuture.allOf(heliFuture, planeFuture, shipFuture, tankFuture, vehicleFuture, bulletFuture, throwableFuture, uavFuture, miscFuture);
        MCH_ModelManager.load("blocks", "drafting_table");
        ((CompletableFuture)allTasks.thenRun(() -> {
            executor.shutdown();
            System.out.println("All model rendering tasks completed successfully.");
        })).exceptionally(ex -> {
            System.err.println(MCH_ClientProxy.jvmdowngrader$concat$lambda$registerModels$15$1(ex.getMessage()));
            ex.printStackTrace();
            executor.shutdown();
            return null;
        });
        allTasks.join();
        MCH_ClientProxy.pauseSplash();
        MCH_ModelManager.makeVBO();
        MCH_ClientProxy.resumeSplash();
    }

    @Override
    public void registerModelsHeli(MCH_HeliInfo info, boolean reload) {
        MCH_ModelManager.setForceReloadMode(reload);
        MCH_ClientProxy.uploadModel(info, "helicopters");
        for (MCH_HeliInfo.Rotor rotor : info.rotorList) {
            rotor.model = this.loadPartModel("helicopters", info.name, info.model, rotor.modelName);
        }
        this.registerCommonPart("helicopters", info);
        MCH_ModelManager.setForceReloadMode(false);
    }

    @Override
    public void registerModelsPlane(MCH_PlaneInfo info, boolean reload) {
        MCH_ModelManager.setForceReloadMode(reload);
        MCH_ClientProxy.uploadModel(info, "planes");
        for (MCH_AircraftInfo.DrawnPart n : info.nozzles) {
            n.model = this.loadPartModel("planes", info.name, info.model, n.modelName);
        }
        for (MCH_PlaneInfo.Rotor r : info.rotorList) {
            r.model = this.loadPartModel("planes", info.name, info.model, r.modelName);
            for (MCH_PlaneInfo.Blade b : r.blades) {
                b.model = this.loadPartModel("planes", info.name, info.model, b.modelName);
            }
        }
        for (MCH_PlaneInfo.Wing w : info.wingList) {
            w.model = this.loadPartModel("planes", info.name, info.model, w.modelName);
            if (w.pylonList == null) continue;
            for (MCH_PlaneInfo.Pylon p : w.pylonList) {
                p.model = this.loadPartModel("planes", info.name, info.model, p.modelName);
            }
        }
        this.registerCommonPart("planes", info);
        MCH_ModelManager.setForceReloadMode(false);
    }

    @Override
    public void registerModelsShip(MCH_ShipInfo info, boolean reload) {
        MCH_ModelManager.setForceReloadMode(reload);
        MCH_ClientProxy.uploadModel(info, "ships");
        for (MCH_AircraftInfo.DrawnPart n : info.nozzles) {
            n.model = this.loadPartModel("ships", info.name, info.model, n.modelName);
        }
        for (MCH_ShipInfo.Rotor r : info.rotorList) {
            r.model = this.loadPartModel("ships", info.name, info.model, r.modelName);
            for (MCH_ShipInfo.Blade b : r.blades) {
                b.model = this.loadPartModel("ships", info.name, info.model, b.modelName);
            }
        }
        for (MCH_ShipInfo.Wing w : info.wingList) {
            w.model = this.loadPartModel("ships", info.name, info.model, w.modelName);
            if (w.pylonList == null) continue;
            for (MCH_ShipInfo.Pylon p : w.pylonList) {
                p.model = this.loadPartModel("ships", info.name, info.model, p.modelName);
            }
        }
        this.registerCommonPart("ships", info);
        MCH_ModelManager.setForceReloadMode(false);
    }

    @Override
    public void registerModelsVehicle(MCH_VehicleInfo info, boolean reload) {
        MCH_ModelManager.setForceReloadMode(reload);
        MCH_ClientProxy.uploadModel(info, "vehicles");
        for (MCH_VehicleInfo.VPart vp : info.partList) {
            vp.model = this.loadPartModel("vehicles", info.name, info.model, vp.modelName);
            if (vp.child == null) continue;
            this.registerVCPModels(info, vp);
        }
        this.registerCommonPart("vehicles", info);
        MCH_ModelManager.setForceReloadMode(false);
    }

    @Override
    public void registerModelsTank(MCH_TankInfo info, boolean reload) {
        MCH_ModelManager.setForceReloadMode(reload);
        MCH_ClientProxy.uploadModel(info, "tanks");
        this.registerCommonPart("tanks", info);
        MCH_ModelManager.setForceReloadMode(false);
    }

    private MCH_BulletModel loadBulletModel(String name) {
        _IModelCustom m = MCH_ModelManager.load("bullets", name);
        return m != null ? new MCH_BulletModel(name, m) : null;
    }

    private _IModelCustom loadPartModel(String path, String name, _IModelCustom body, String part) {
        return body instanceof W_ModelCustom && ((W_ModelCustom)body).containsPart(MCH_ClientProxy.jvmdowngrader$concat$loadPartModel$1(part)) ? null : MCH_ModelManager.load(path, MCH_ClientProxy.jvmdowngrader$concat$loadPartModel$1(name, part), true);
    }

    private void registerCommonPart(String path, MCH_AircraftInfo info) {
        info.hatchList.parallelStream().forEach(h -> {
            h.model = this.loadPartModel(path, info.name, info.model, h.modelName);
        });
        info.cameraList.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partThrottle.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partRotPart.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partWeapon.parallelStream().forEach(p -> {
            p.model = this.loadPartModel(path, info.name, info.model, p.modelName);
            p.child.parallelStream().forEach(wc -> {
                wc.model = this.loadPartModel(path, info.name, info.model, wc.modelName);
            });
        });
        info.canopyList.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.landingGear.parallelStream().forEach(n -> {
            n.model = this.loadPartModel(path, info.name, info.model, n.modelName);
        });
        info.partWeaponBay.parallelStream().forEach(w -> {
            w.model = this.loadPartModel(path, info.name, info.model, w.modelName);
        });
        info.partCrawlerTrack.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partTrackRoller.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partWheel.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
        info.partSteeringWheel.parallelStream().forEach(c -> {
            c.model = this.loadPartModel(path, info.name, info.model, c.modelName);
        });
    }

    private void registerVCPModels(MCH_VehicleInfo info, MCH_VehicleInfo.VPart vp) {
        for (MCH_VehicleInfo.VPart vcp : vp.child) {
            vcp.model = this.loadPartModel("vehicles", info.name, info.model, vcp.modelName);
            if (vcp.child == null) continue;
            this.registerVCPModels(info, vcp);
        }
    }

    @Override
    public void registerClientTick() {
        Minecraft mc = Minecraft.func_71410_x();
        MCH_ClientCommonTickHandler.instance = new MCH_ClientCommonTickHandler(mc, MCH_MOD.config);
        W_TickRegistry.registerTickHandler(MCH_ClientCommonTickHandler.instance, Side.CLIENT);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public String side() {
        return "Client";
    }

    @Override
    public MCH_SoundUpdater CreateSoundUpdater(MCH_EntityAircraft aircraft) {
        return aircraft != null && aircraft.field_70170_p.field_72995_K ? new MCH_SoundUpdater(Minecraft.func_71410_x(), aircraft, Minecraft.func_71410_x().field_71439_g) : null;
    }

    @Override
    public void registerSounds() {
        super.registerSounds();
    }

    @Override
    public void loadConfig(String fileName) {
        this.lastConfigFileName = fileName;
        this.config = new MCH_Config(Minecraft.func_71410_x().field_71412_D.getPath(), MCH_ClientProxy.jvmdowngrader$concat$loadConfig$1(fileName));
        this.config.load();
        this.config.write();
    }

    @Override
    public void reconfig() {
        MCH_Lib.DbgLog(false, "MCH_ClientProxy.reconfig()", new Object[0]);
        this.loadConfig(this.lastConfigFileName);
        MCH_ClientCommonTickHandler.instance.updatekeybind(this.config);
    }

    @Override
    public void reloadHUD() {
        ContentRegistries.hud().reloadAll();
    }

    @Override
    public Entity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MCH_CameraManager());
        MinecraftForge.EVENT_BUS.register((Object)new MCH_ClientEventHook());
        super.init();
    }

    @Override
    public void setCreativeDigDelay(int n) {
        W_Reflection.setCreativeDigSpeed(n);
    }

    @Override
    public boolean isFirstPerson() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
    }

    @Override
    public boolean isSinglePlayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @Override
    public void readClientModList() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            MCH_MultiplayClient.readModList(mc.func_110432_I().func_148255_b(), mc.func_110432_I().func_111285_a());
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    @Override
    public void printChatMessage(ITextComponent chat, int showTime, int pos) {
        ((MCH_GuiTitle)MCH_ClientCommonTickHandler.instance.gui_Title).setupTitle(chat, showTime, pos);
    }

    @Override
    public void hitBullet() {
        MCH_ClientCommonTickHandler.instance.gui_Common.hitBullet();
    }

    @Override
    public void clientLocked() {
        MCH_ClientCommonTickHandler.isLocked = true;
    }

    @Override
    public void setRenderEntityDistanceWeight(double renderDistWeight) {
        Entity.func_184227_b((double)renderDistWeight);
    }

    @Override
    public List<AddonPack> loadAddonPacks(File addonDir) {
        return AddonManager.loadAddonsAndAddResources(addonDir);
    }

    @Override
    public boolean canLoadContentDirName(String dir) {
        return "hud".equals(dir) || super.canLoadContentDirName(dir);
    }

    @Override
    public void updateGeneratedLanguage() {
        W_LanguageRegistry.updateGeneratedLang();
    }

    @Override
    @Deprecated
    public void updateSoundsJson() {
    }

    @Override
    public void registerParticleTextures(TextureStitchEvent.Pre event) {
        TextureMap m = event.getMap();
        m.func_174942_a(MCH_EntityParticleExplode.FLASH);
        m.func_174942_a(HudGPS.GPS_POS);
        m.func_174942_a(HudRWR.RWR);
        m.func_174942_a(HudRWR.RWR_FAC);
        m.func_174942_a(HudRWR.RWR_HELI);
        m.func_174942_a(HudRWR.RWR_TANK);
        m.func_174942_a(HudMortarRadar.CROSS);
        m.func_174942_a(HudMortarRadar.RADAR);
        m.func_174942_a(HudMortarRadar.TARGET);
        GLStateManagerExt.pollSize();
    }

    @Override
    public void registerShaders(TextureStitchEvent.Post event) {
        ShaderRegistry.init();
    }

    static {
        Class splash;
        if (Loader.isModLoaded((String)"modernsplash")) {
            try {
                splash = Class.forName("gkappa.modernsplash.CustomSplash");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("ModernSplash loaded but failed to find gkappa.modernsplash.CustomSplash", e);
            }
        } else {
            splash = SplashProgress.class;
        }
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Field splashThread = splash.getDeclaredField("thread");
            Field splashEnabled = splash.getDeclaredField("enabled");
            splashThread.setAccessible(true);
            splashEnabled.setAccessible(true);
            splashThreadGetter = lookup.unreflectGetter(splashThread);
            splashEnabledGetter = lookup.unreflectGetter(splashEnabled);
            splashPauseHandle = lookup.findStatic(splash, "pause", MethodType.methodType(Void.TYPE));
            splashResumeHandle = lookup.findStatic(splash, "resume", MethodType.methodType(Void.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadPartModel$1(String string) {
        return "$" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadPartModel$1(String string, String string2) {
        return string + "_" + string2;
    }

    private static /* synthetic */ String jvmdowngrader$concat$loadConfig$1(String string) {
        return "/" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$15$1(String string) {
        return "Error during model rendering: " + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$13$1(long l) {
        return "[MCH-LOADER][THROWABLES] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$11$1(long l) {
        return "[MCH-LOADER][VEHICLE] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$9$1(long l) {
        return "[MCH-LOADER][TANK] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$7$1(long l) {
        return "[MCH-LOADER][SHIP] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$5$1(long l) {
        return "[MCH-LOADER][PLANE] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$3$1(long l) {
        return "[MCH-LOADER][HELI] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$2$1(long l) {
        return "[MCH-LOADER][UAV] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$1$3(long l) {
        return "[BULLETS] Loaded in " + l + " ms";
    }

    private static /* synthetic */ String jvmdowngrader$concat$lambda$registerModels$0$1(long l) {
        return "[MCH-LOADER][MISC] Loaded in " + l + " ms";
    }
}

