/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.script;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.script.AviatorScriptEngine;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class AviatorScriptEngineFactory
implements ScriptEngineFactory {
    private static final List<String> extensions = Collections.unmodifiableList(Arrays.asList("av", "aviator"));
    private static final List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList("text/aviator", "text/aviatorscript"));
    private static final List<String> names = Collections.unmodifiableList(Arrays.asList("Aviator", "aviator", "aviatorscript", "AviatorScript"));
    private static final Map<String, String> PARAM_MAP = new HashMap<String, String>();

    public static final AviatorScriptEngineFactory newInstance() {
        return new AviatorScriptEngineFactory();
    }

    @Override
    public String getEngineName() {
        return PARAM_MAP.get("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return PARAM_MAP.get("javax.script.engine_version");
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return PARAM_MAP.get("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return PARAM_MAP.get("javax.script.language_version");
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args2) {
        StringBuilder sb = new StringBuilder(m);
        sb.append("(").append(obj);
        if (args2 != null) {
            for (String s : args2) {
                sb.append(",").append(s);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        return "print(+" + toDisplay + ")";
    }

    @Override
    public Object getParameter(String key) {
        return PARAM_MAP.get(key);
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String stmt : statements) {
            sb.append(stmt).append(";");
        }
        return sb.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new AviatorScriptEngine(this);
    }

    static {
        PARAM_MAP.put("javax.script.engine", "Aviator");
        PARAM_MAP.put("javax.script.engine_version", AviatorEvaluator.VERSION);
        PARAM_MAP.put("javax.script.language", "AviatorScript");
        PARAM_MAP.put("javax.script.language_version", AviatorEvaluator.VERSION);
    }
}

