/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.op;

import com.googlecode.aviator.exception.IllegalArityException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class OperationRuntime {
    private static final ThreadLocal<AviatorObject[]> TWO_ARRGS = new ThreadLocal<AviatorObject[]>(){

        @Override
        protected AviatorObject[] initialValue() {
            return new AviatorObject[2];
        }
    };
    private static final ThreadLocal<AviatorObject[]> ONE_ARG = new ThreadLocal<AviatorObject[]>(){

        @Override
        protected AviatorObject[] initialValue() {
            return new AviatorObject[1];
        }
    };
    private static final String WHITE_SPACE = " ";
    private static final String TRACE_PREFIX = "         ";

    public static AviatorObject eval(Map<String, Object> env, AviatorObject[] args2, OperatorType opType) {
        AviatorFunction func = RuntimeUtils.getInstance(env).getOpFunction(opType);
        AviatorObject ret = OperationRuntime.eval0(env, args2, opType, func);
        if (RuntimeUtils.isTracedEval(env)) {
            OperationRuntime.trace(env, opType, ret, args2);
        }
        return ret;
    }

    private static AviatorObject eval0(Map<String, Object> env, AviatorObject[] args2, OperatorType opType, AviatorFunction func) {
        if (func == null) {
            return opType.eval(args2, env);
        }
        return OperationRuntime.evalOpFunction(env, args2, opType, func);
    }

    public static AviatorObject evalOpFunction(Map<String, Object> env, AviatorObject[] args2, OperatorType opType, AviatorFunction func) {
        switch (opType.getArity()) {
            case 1: {
                return func.call(env, args2[0]);
            }
            case 2: {
                return func.call(env, args2[0], args2[1]);
            }
            case 3: {
                return func.call(env, args2[0], args2[1], args2[2]);
            }
        }
        throw new IllegalArityException("Too many arguments.");
    }

    public static AviatorObject eval(AviatorObject arg, Map<String, Object> env, OperatorType opType) {
        AviatorFunction func = RuntimeUtils.getInstance(env).getOpFunction(opType);
        AviatorObject ret = OperationRuntime.eval0(arg, env, opType, func);
        if (RuntimeUtils.isTracedEval(env)) {
            OperationRuntime.trace(env, opType, ret, arg);
        }
        return ret;
    }

    private static AviatorObject eval0(AviatorObject arg, Map<String, Object> env, OperatorType opType, AviatorFunction func) {
        if (func == null) {
            AviatorObject[] args2 = ONE_ARG.get();
            args2[0] = arg;
            return opType.eval(args2, env);
        }
        return func.call(env, arg);
    }

    public static AviatorObject eval(AviatorObject left, Map<String, Object> env, AviatorObject right, OperatorType opType) {
        return OperationRuntime.eval(left, right, env, opType);
    }

    public static AviatorObject eval(AviatorObject left, AviatorObject right, Map<String, Object> env, OperatorType opType) {
        AviatorFunction func = RuntimeUtils.getInstance(env).getOpFunction(opType);
        AviatorObject ret = OperationRuntime.eval0(left, right, env, opType, func);
        if (RuntimeUtils.isTracedEval(env)) {
            OperationRuntime.trace(env, opType, ret, left, right);
        }
        return ret;
    }

    private static AviatorObject eval0(AviatorObject left, AviatorObject right, Map<String, Object> env, OperatorType opType, AviatorFunction func) {
        if (func == null) {
            AviatorObject[] args2 = TWO_ARRGS.get();
            args2[0] = left;
            args2[1] = right;
            return opType.eval(args2, env);
        }
        return func.call(env, left, right);
    }

    public static final boolean hasRuntimeContext(Map<String, Object> env, OperatorType opType) {
        return OperationRuntime.containsOpFunction(env, opType) || RuntimeUtils.isTracedEval(env);
    }

    public static boolean containsOpFunction(Map<String, Object> env, OperatorType opType) {
        return RuntimeUtils.getInstance(env).getOpsMap().containsKey((Object)opType);
    }

    private static String desc(AviatorObject arg, Map<String, Object> env) {
        if (arg != null) {
            return arg.desc(env);
        }
        return Variable.NIL.getLexeme();
    }

    private static void trace(Map<String, Object> env, OperatorType opType, AviatorObject result, AviatorObject ... args2) {
        StringBuilder argsDec = new StringBuilder();
        argsDec.append(OperationRuntime.desc(args2[0], env));
        for (int i = 1; i < args2.length; ++i) {
            if (args2[i] == null) continue;
            argsDec.append(WHITE_SPACE).append(opType.token).append(WHITE_SPACE).append(OperationRuntime.desc(args2[i], env));
        }
        RuntimeUtils.printlnTrace(env, TRACE_PREFIX + argsDec + " => " + OperationRuntime.desc(result, env));
    }
}

