/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.internal;

import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Env;
import java.util.Map;

public class UseFunction
extends AbstractVariadicFunction {
    private static final long serialVersionUID = 1710427343500339000L;
    public static final UseFunction INSTANCE = new UseFunction();

    private UseFunction() {
    }

    @Override
    public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args2) {
        if (args2.length < 3) {
            throw new IllegalArgumentException("Wrong arguments(" + args2.length + ") passed to __use variadicCall");
        }
        if (args2[0].getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Can't use other aviator type except varaible");
        }
        String packageSym = ((AviatorJavaType)args2[0]).getName();
        assert (env instanceof Env);
        Env theEnv = (Env)env;
        for (int i = 1; i < args2.length; ++i) {
            if (args2[i].getAviatorType() != AviatorType.JavaType) {
                throw new IllegalArgumentException("Can't use other aviator type except varaible");
            }
            String name = ((AviatorJavaType)args2[i]).getName();
            this.addSym(theEnv, packageSym, name);
        }
        return AviatorNil.NIL;
    }

    private void addSym(Env theEnv, String packageSym, String name) {
        if (name.equals("*")) {
            theEnv.addPackageSymbol(packageSym);
        } else {
            theEnv.addSymbol(packageSym + name);
        }
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        if (arg1.getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Can't use other aviator type except varaible");
        }
        String sym = ((AviatorJavaType)arg1).getName();
        assert (env instanceof Env);
        ((Env)env).addSymbol(sym);
        return AviatorNil.NIL;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        if (arg1.getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Can't use other aviator type except varaible");
        }
        if (arg2.getAviatorType() != AviatorType.JavaType) {
            throw new IllegalArgumentException("Can't use other aviator type except varaible");
        }
        String packageSym = ((AviatorJavaType)arg1).getName();
        String name = ((AviatorJavaType)arg2).getName();
        assert (env instanceof Env);
        Env theEnv = (Env)env;
        this.addSym(theEnv, packageSym, name);
        return AviatorNil.NIL;
    }

    @Override
    public String getName() {
        return Constants.USE_VAR.getLexeme();
    }
}

