/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function;

import com.googlecode.aviator.exception.FunctionNotFoundException;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;

public class DispatchFunction
extends AbstractVariadicFunction {
    private static final Object[] EMPTY_VAR_ARGS = new Object[0];
    private static final long serialVersionUID = 5993768652338524385L;
    private final IdentityHashMap<Integer, LambdaFunction> functions = new IdentityHashMap();
    private final TreeMap<Integer, LambdaFunction> variadicFunctions = new TreeMap();
    private final String name;

    public DispatchFunction(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void install(LambdaFunction fn) {
        if (fn.isVariadic()) {
            this.variadicFunctions.put(fn.getArity(), fn);
        } else {
            this.functions.put(fn.getArity(), fn);
        }
        fn.setInstalled(true);
    }

    @Override
    public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args2) {
        int arity = args2.length;
        LambdaFunction fn = this.functions.get(arity);
        if (fn == null) {
            Map.Entry<Integer, LambdaFunction> entry;
            fn = this.variadicFunctions.get(arity + 1);
            if (fn == null && (entry = this.variadicFunctions.floorEntry(arity)) != null) {
                fn = entry.getValue();
            }
            if (fn == null) {
                throw new FunctionNotFoundException("Function `" + this.name + "` with args(" + arity + ") not found");
            }
        }
        assert (arity + 1 >= arity);
        if (fn.isVariadic()) {
            args2 = DispatchFunction.processVariadicArgs(env, arity, fn, args2);
        }
        switch (fn.getArity()) {
            case 0: {
                return fn.call(env);
            }
            case 1: {
                return fn.call(env, args2[0]);
            }
            case 2: {
                return fn.call(env, args2[0], args2[1]);
            }
            case 3: {
                return fn.call(env, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3]);
            }
            case 5: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4]);
            }
            case 6: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5]);
            }
            case 7: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6]);
            }
            case 8: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7]);
            }
            case 9: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8]);
            }
            case 10: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9]);
            }
            case 11: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10]);
            }
            case 12: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11]);
            }
            case 13: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12]);
            }
            case 14: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13]);
            }
            case 15: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14]);
            }
            case 16: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15]);
            }
            case 17: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16]);
            }
            case 18: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17]);
            }
            case 19: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18]);
            }
            case 20: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18], args2[19]);
            }
        }
        assert (args2.length >= 20);
        AviatorObject[] remainingArgs = new AviatorObject[args2.length - 20];
        System.arraycopy(args2, 20, remainingArgs, 0, remainingArgs.length);
        return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18], args2[19], remainingArgs);
    }

    static AviatorObject[] processVariadicArgs(Map<String, Object> env, int arity, LambdaFunction fn, AviatorObject[] args2) {
        if (arity + 1 == fn.getArity()) {
            AviatorObject[] newArgs = new AviatorObject[arity + 1];
            System.arraycopy(args2, 0, newArgs, 0, arity);
            newArgs[arity] = AviatorRuntimeJavaType.valueOf(EMPTY_VAR_ARGS);
            args2 = newArgs;
        } else {
            AviatorObject[] newArgs = new AviatorObject[fn.getArity()];
            System.arraycopy(args2, 0, newArgs, 0, fn.getArity() - 1);
            Object[] varArgs = new Object[arity - fn.getArity() + 1];
            for (int i = 0; i < varArgs.length; ++i) {
                varArgs[i] = args2[fn.getArity() - 1 + i].getValue(env);
            }
            newArgs[fn.getArity() - 1] = AviatorRuntimeJavaType.valueOf(varArgs);
            args2 = newArgs;
        }
        return args2;
    }
}

