/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime;

import com.googlecode.aviator.FunctionMissing;
import com.googlecode.aviator.exception.FunctionNotFoundException;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.Reflector;
import java.util.Map;

public class JavaMethodReflectionFunctionMissing
implements FunctionMissing {
    private static final long serialVersionUID = -7829608231403725185L;
    private static final JavaMethodReflectionFunctionMissing INSTANCE = new JavaMethodReflectionFunctionMissing();

    private JavaMethodReflectionFunctionMissing() {
    }

    public static JavaMethodReflectionFunctionMissing getInstance() {
        return INSTANCE;
    }

    @Override
    public AviatorObject onFunctionMissing(String name, Map<String, Object> env, AviatorObject ... args2) {
        if (args2 == null || args2.length < 1) {
            throw new FunctionNotFoundException("Function not found: " + name + ", could not resolve with no arguments");
        }
        Object firstArg = args2[0].getValue(env);
        if (firstArg == null) {
            throw new FunctionNotFoundException("Function not found: " + name + ", the first argument is null");
        }
        Class<?> clazz = firstArg.getClass();
        Object[] jArgs = new Object[args2.length - 1];
        for (int i = 1; i < args2.length; ++i) {
            jArgs[i - 1] = args2[i].getValue(env);
        }
        return FunctionUtils.wrapReturn(Reflector.invokeInstanceMethod(clazz, name, firstArg, Reflector.getInstanceMethods(clazz, name), jArgs));
    }
}

