/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer.token;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.exception.IllegalArityException;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public enum OperatorType {
    BIT_OR("|", 2),
    BIT_AND("&", 2),
    BIT_XOR("^", 2),
    BIT_NOT("~", 1),
    SHIFT_LEFT("<<", 2),
    SHIFT_RIGHT(">>", 2),
    U_SHIFT_RIGHT(">>>", 2),
    NOT("!", 1),
    MULT("*", 2),
    Exponent("**", 2),
    DIV("/", 2),
    MOD("%", 2),
    ADD("+", 2),
    SUB("-sub", 2),
    LT("<", 2),
    LE("<=", 2),
    GT(">", 2),
    GE(">=", 2),
    EQ("==", 2),
    NEQ("!=", 2),
    AND("&&", 2),
    MATCH("=~", 2),
    OR("||", 2),
    INDEX("[]", 2),
    FUNC("()", Integer.MAX_VALUE),
    NEG("-neg", 1),
    TERNARY("?:", 3),
    ASSIGNMENT("=", 2),
    DEFINE("=", 2);

    public final String token;
    public final int arity;

    private OperatorType(String token, int operandCount) {
        this.token = token;
        this.arity = operandCount;
    }

    public AviatorObject eval(AviatorObject[] args2, Map<String, Object> env) {
        if (args2.length < this.arity) {
            throw new IllegalArityException("Expect " + this.arity + " parameters for " + this.name() + ", but have " + args2.length + " arguments.");
        }
        switch (this) {
            case ADD: {
                return args2[0].add(args2[1], env);
            }
            case SUB: {
                return args2[0].sub(args2[1], env);
            }
            case MOD: {
                return args2[0].mod(args2[1], env);
            }
            case DEFINE: {
                if (!(args2[0] instanceof AviatorJavaType)) {
                    throw new IllegalArgumentException(args2[0].desc(env) + " can't be as a left value.");
                }
                args2[0].defineValue(args2[1], env);
                return args2[1];
            }
            case ASSIGNMENT: {
                if (!(args2[0] instanceof AviatorJavaType)) {
                    throw new ExpressionRuntimeException(args2[0].desc(env) + " can't be a left value for assignment.");
                }
                args2[0].setValue(args2[1], env);
                return args2[1];
            }
            case DIV: {
                return args2[0].div(args2[1], env);
            }
            case MULT: {
                return args2[0].mult(args2[1], env);
            }
            case Exponent: {
                return args2[0].exponent(args2[1], env);
            }
            case EQ: {
                int result = args2[0].compareEq(args2[1], env);
                return AviatorBoolean.valueOf(result == 0);
            }
            case NEQ: {
                int result = args2[0].compareEq(args2[1], env);
                return AviatorBoolean.valueOf(result != 0);
            }
            case LT: {
                int result = args2[0].compare(args2[1], env);
                return AviatorBoolean.valueOf(result < 0);
            }
            case LE: {
                int result = args2[0].compare(args2[1], env);
                return AviatorBoolean.valueOf(result <= 0);
            }
            case GT: {
                int result = args2[0].compare(args2[1], env);
                return AviatorBoolean.valueOf(result > 0);
            }
            case GE: {
                int result = args2[0].compare(args2[1], env);
                return AviatorBoolean.valueOf(result >= 0);
            }
            case NOT: {
                return args2[0].not(env);
            }
            case NEG: {
                return args2[0].neg(env);
            }
            case MATCH: {
                return args2[1].match(args2[0], env);
            }
            case AND: {
                return args2[0].booleanValue(env) && args2[1].booleanValue(env) ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case OR: {
                return args2[0].booleanValue(env) || args2[1].booleanValue(env) ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
            }
            case FUNC: {
                break;
            }
            case INDEX: {
                return ((AviatorJavaType)args2[0]).getElement(env, args2[1]);
            }
            case TERNARY: {
                return args2[0].booleanValue(env) ? args2[1] : args2[2];
            }
            case BIT_OR: {
                return args2[0].bitOr(args2[1], env);
            }
            case BIT_AND: {
                return args2[0].bitAnd(args2[1], env);
            }
            case BIT_XOR: {
                return args2[0].bitXor(args2[1], env);
            }
            case SHIFT_LEFT: {
                return args2[0].shiftLeft(args2[1], env);
            }
            case SHIFT_RIGHT: {
                return args2[0].shiftRight(args2[1], env);
            }
            case U_SHIFT_RIGHT: {
                return args2[0].unsignedShiftRight(args2[1], env);
            }
            case BIT_NOT: {
                return args2[0].bitNot(env);
            }
        }
        return null;
    }

    public String getToken() {
        return this.token;
    }

    public int getArity() {
        return this.arity;
    }
}

