/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.interpreter.ir;

import com.googlecode.aviator.code.interpreter.IR;
import com.googlecode.aviator.code.interpreter.InterpretContext;
import com.googlecode.aviator.code.interpreter.ir.SourceInfo;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.TraceFunction;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.Env;

public class SendIR
implements IR {
    private static final long serialVersionUID = 2747763526113139010L;
    private final String name;
    private final int arity;
    private final boolean unpackArgs;
    private int funcId = -1;
    private final SourceInfo sourceInfo;

    public SendIR(String name, int arity, boolean unpackArgs, int funcId, SourceInfo sourceInfo) {
        this.name = name;
        this.arity = arity;
        this.unpackArgs = unpackArgs;
        this.funcId = funcId;
        this.sourceInfo = sourceInfo;
    }

    private AviatorObject callFn(AviatorFunction fn, AviatorObject[] args2, int arity, Env env) {
        if (arity == 0) {
            return fn.call(env);
        }
        switch (arity) {
            case 1: {
                return fn.call(env, args2[0]);
            }
            case 2: {
                return fn.call(env, args2[0], args2[1]);
            }
            case 3: {
                return fn.call(env, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3]);
            }
            case 5: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4]);
            }
            case 6: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5]);
            }
            case 7: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6]);
            }
            case 8: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7]);
            }
            case 9: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8]);
            }
            case 10: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9]);
            }
            case 11: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10]);
            }
            case 12: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11]);
            }
            case 13: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12]);
            }
            case 14: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13]);
            }
            case 15: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14]);
            }
            case 16: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15]);
            }
            case 17: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16]);
            }
            case 18: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17]);
            }
            case 19: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18]);
            }
            case 20: {
                return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18], args2[19]);
            }
        }
        assert (args2.length >= 20);
        AviatorObject[] remainingArgs = new AviatorObject[args2.length - 20];
        System.arraycopy(args2, 20, remainingArgs, 0, remainingArgs.length);
        return fn.call(env, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], args2[6], args2[7], args2[8], args2[9], args2[10], args2[11], args2[12], args2[13], args2[14], args2[15], args2[16], args2[17], args2[18], args2[19], remainingArgs);
    }

    @Override
    public void eval(InterpretContext context) {
        AviatorFunction fn = null;
        if (this.name != null) {
            fn = RuntimeUtils.getFunction(context.getEnv(), this.name);
        }
        int i = this.arity;
        AviatorObject[] args2 = new AviatorObject[this.arity];
        while (--i >= 0) {
            args2[i] = context.pop();
        }
        if (this.name == null) {
            fn = (AviatorFunction)((Object)context.pop());
        }
        if (RuntimeUtils.isTracedEval(context.getEnv())) {
            fn = TraceFunction.wrapTrace(fn);
        }
        if (this.unpackArgs) {
            fn = RuntimeUtils.unpackArgsFunction(fn);
        }
        if (this.funcId >= 0) {
            context.getEnv().put("__fas__", (Object)this.funcId);
        }
        context.push(this.callFn(fn, args2, this.arity, context.getEnv()));
        context.dispatch();
    }

    @Override
    public boolean mayBeCost() {
        return true;
    }

    public String toString() {
        return "send " + (this.name == null ? "<top>" : this.name) + ", " + this.arity + ", " + this.unpackArgs + "      " + this.sourceInfo;
    }
}

