/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.ExpressionAccessor;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.LiteralExpression;
import com.googlecode.aviator.code.CodeGenerator;
import com.googlecode.aviator.code.EvalCodeGenerator;
import com.googlecode.aviator.code.LambdaGenerator;
import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.DelegateToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.OperatorToken;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.lexer.token.PatternToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.parser.CompileTypes;
import com.googlecode.aviator.parser.ExpressionParser;
import com.googlecode.aviator.parser.Parser;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionParam;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.op.OperationRuntime;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorPattern;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorString;
import com.googlecode.aviator.utils.Env;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class OptimizeCodeGenerator
implements CodeGenerator {
    private final EvalCodeGenerator codeGen;
    private final List<Token<?>> tokenList = new ArrayList();
    private LambdaGenerator lambdaGenerator;
    private CodeGenerator parentCodeGenerator;
    private final AviatorEvaluatorInstance instance;
    private Parser parser;
    private Env compileEnv;
    private Map<String, LambdaFunctionBootstrap> lambdaBootstraps;
    private final String sourceFile;

    public OptimizeCodeGenerator(AviatorEvaluatorInstance instance, String sourceFile, ClassLoader classLoader, OutputStream traceOutStream) {
        this.instance = instance;
        this.sourceFile = sourceFile;
        this.codeGen = instance.newEvalCodeGenerator((AviatorClassLoader)classLoader, sourceFile);
    }

    private Env getCompileEnv() {
        if (this.compileEnv == null) {
            this.compileEnv = new Env();
            this.compileEnv.setInstance(this.instance);
        }
        return this.compileEnv;
    }

    @Override
    public void setParser(Parser parser) {
        this.parser = parser;
        this.codeGen.setParser(parser);
    }

    private Map<Integer, DelegateToken.DelegateTokenType> getIndex2DelegateTypeMap(OperatorType opType) {
        HashMap<Integer, DelegateToken.DelegateTokenType> result = new HashMap<Integer, DelegateToken.DelegateTokenType>();
        switch (opType) {
            case AND: {
                result.put(2, DelegateToken.DelegateTokenType.And_Left);
                break;
            }
            case OR: {
                result.put(2, DelegateToken.DelegateTokenType.Join_Left);
                break;
            }
            case TERNARY: {
                result.put(4, DelegateToken.DelegateTokenType.Ternary_Boolean);
                result.put(2, DelegateToken.DelegateTokenType.Ternary_Left);
            }
        }
        return result;
    }

    private int execute() {
        int exeCount = 0;
        int size = this.tokenList.size();
        this.printTokenList();
        block3: for (int i = 0; i < size; ++i) {
            Token<?> token = this.tokenList.get(i);
            if (token.getType() != Token.TokenType.Operator) continue;
            OperatorToken op = (OperatorToken)token;
            OperatorType operatorType = op.getOperatorType();
            int operandCount = operatorType.getArity();
            switch (operatorType) {
                case FUNC: 
                case INDEX: {
                    continue block3;
                }
                default: {
                    if (OperationRuntime.hasRuntimeContext(this.getCompileEnv(), operatorType)) continue block3;
                    Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType = this.getIndex2DelegateTypeMap(operatorType);
                    int result = this.executeOperator(index2DelegateType, token, operatorType, i, operandCount);
                    if (result < 0) {
                        this.compactTokenList();
                        return exeCount;
                    }
                    exeCount += result;
                }
            }
        }
        this.compactTokenList();
        return exeCount;
    }

    private int executeOperator(Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType, Token<?> operatorToken, OperatorType operatorType, int operatorIndex, int operandCount) {
        Token<?> token = null;
        operandCount += index2DelegateType.size();
        boolean canExecute = true;
        int count = 0;
        int operandStartIndex = -1;
        for (int j = operatorIndex - 1; j >= 0; --j) {
            token = this.tokenList.get(j);
            if (token == null) {
                return -1;
            }
            Token.TokenType tokenType = token.getType();
            if (!this.isLiteralOperand(token, tokenType, count + 1, index2DelegateType)) {
                canExecute = false;
                break;
            }
            if (++count != operandCount) continue;
            operandStartIndex = j;
            break;
        }
        if (canExecute) {
            AviatorObject[] args2 = new AviatorObject[operandCount];
            int index = 0;
            for (int j = operandStartIndex; j < operatorIndex; ++j) {
                token = this.tokenList.get(j);
                if (token.getType() == Token.TokenType.Delegate) {
                    this.tokenList.set(j, null);
                    continue;
                }
                args2[index++] = this.getAviatorObjectFromToken(token);
                this.tokenList.set(j, null);
            }
            AviatorObject result = OperationRuntime.eval(this.getCompileEnv(), args2, operatorType);
            this.tokenList.set(operatorIndex, this.getTokenFromOperand(operatorToken, result));
            return 1;
        }
        return 0;
    }

    private boolean isLiteralOperand(Token<?> token, Token.TokenType tokenType, int index, Map<Integer, DelegateToken.DelegateTokenType> index2DelegateType) {
        switch (tokenType) {
            case Variable: {
                return token == Variable.TRUE || token == Variable.FALSE || token == Variable.NIL;
            }
            case Delegate: {
                DelegateToken.DelegateTokenType targetDelegateTokenType = index2DelegateType.get(index);
                if (targetDelegateTokenType == null) break;
                return targetDelegateTokenType == ((DelegateToken)token).getDelegateTokenType();
            }
            case Char: 
            case Number: 
            case Pattern: {
                return true;
            }
            case String: {
                return !this.instance.isFeatureEnabled(Feature.StringInterpolation);
            }
        }
        return false;
    }

    private Token<?> getTokenFromOperand(Token<?> operatorToken, AviatorObject operand) {
        Token<Object> token = null;
        switch (operand.getAviatorType()) {
            case JavaType: {
                if (operand instanceof AviatorRuntimeJavaType) {
                    Object val = operand.getValue(null);
                    if (val == null) {
                        token = Variable.NIL;
                        break;
                    }
                    if (val instanceof Number) {
                        token = new NumberToken((Number)val, val.toString(), operatorToken.getLineNo(), operatorToken.getStartIndex());
                        break;
                    }
                    if (val instanceof String || val instanceof Character) {
                        String s = val.toString();
                        token = new StringToken(s, operatorToken.getLineNo(), operatorToken.getStartIndex()).withMeta("hasInterpolation", s.contains("#"));
                        break;
                    }
                    if (val instanceof Pattern) {
                        token = new PatternToken(((Pattern)val).pattern(), operatorToken.getLineNo(), operatorToken.getStartIndex());
                        break;
                    }
                    if (val instanceof Boolean) {
                        token = (Boolean)val != false ? Variable.TRUE : Variable.FALSE;
                        break;
                    }
                    throw new CompileExpressionErrorException("Invalid operand:" + operand.desc(null));
                }
                throw new CompileExpressionErrorException("Invalid operand:" + operand.desc(null));
            }
            case Boolean: {
                token = operand.booleanValue(null) ? Variable.TRUE : Variable.FALSE;
                break;
            }
            case Nil: {
                token = Variable.NIL;
                break;
            }
            case BigInt: 
            case Decimal: 
            case Double: 
            case Long: {
                Number value = (Number)operand.getValue(null);
                token = new NumberToken(value, value.toString(), operatorToken.getLineNo(), operatorToken.getStartIndex());
                break;
            }
            case String: {
                String str = (String)operand.getValue(null);
                token = new StringToken(str, operatorToken.getLineNo(), operatorToken.getStartIndex());
                break;
            }
            case Pattern: {
                token = new PatternToken(((AviatorPattern)operand).getPattern().pattern(), operatorToken.getLineNo(), operatorToken.getStartIndex());
            }
        }
        return token;
    }

    private void compactTokenList() {
        Iterator<Token<?>> it = this.tokenList.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
    }

    private AviatorObject getAviatorObjectFromToken(Token<?> lookhead) {
        AviatorObject result = null;
        switch (lookhead.getType()) {
            case Number: {
                NumberToken numberToken = (NumberToken)lookhead;
                Number num = numberToken.getNumber();
                result = AviatorNumber.valueOf(num);
                break;
            }
            case String: {
                result = new AviatorString((String)lookhead.getValue(null), true, true, lookhead.getLineNo());
                break;
            }
            case Pattern: {
                result = new AviatorPattern((String)lookhead.getValue(null));
                break;
            }
            case Variable: {
                if (lookhead == Variable.TRUE) {
                    result = AviatorBoolean.TRUE;
                    break;
                }
                if (lookhead == Variable.FALSE) {
                    result = AviatorBoolean.FALSE;
                    break;
                }
                if (lookhead != Variable.NIL) break;
                result = AviatorNil.NIL;
                break;
            }
            case Char: {
                result = new AviatorString(String.valueOf(lookhead.getValue(null)), true, true, lookhead.getLineNo());
            }
        }
        return result;
    }

    @Override
    public Expression getResult(boolean unboxObject) {
        while (this.execute() > 0) {
        }
        LinkedHashMap<String, VariableMeta> variables = new LinkedHashMap<String, VariableMeta>();
        HashMap<String, Integer> methods = new HashMap<String, Integer>();
        HashSet constants = new HashSet();
        for (Token<?> token : this.tokenList) {
            if (ExpressionParser.isConstant(token, this.instance)) {
                constants.add(token);
            }
            switch (token.getType()) {
                case Variable: {
                    if (SymbolTable.isReservedKeyword((Variable)token) || token.getMeta("useClassOrPkg", false).booleanValue()) break;
                    String varName = token.getLexeme();
                    VariableMeta meta = (VariableMeta)variables.get(varName);
                    if (meta == null) {
                        meta = new VariableMeta((CompileTypes)token.getMeta("type"), varName, token.getMeta("isInitialized", false), token.getStartIndex());
                        variables.put(varName, meta);
                        break;
                    }
                    meta.add(token);
                    break;
                }
                case Delegate: {
                    Token<?> realToken;
                    DelegateToken delegateToken = (DelegateToken)token;
                    if (delegateToken.getDelegateTokenType() == DelegateToken.DelegateTokenType.Method_Name) {
                        realToken = delegateToken.getToken();
                        if (realToken == null || realToken.getType() != Token.TokenType.Variable) break;
                        String methodName = token.getLexeme();
                        if (!methods.containsKey(methodName)) {
                            methods.put(methodName, 1);
                            break;
                        }
                        methods.put(methodName, (Integer)methods.get(methodName) + 1);
                        break;
                    }
                    if (delegateToken.getDelegateTokenType() != DelegateToken.DelegateTokenType.Array || (realToken = delegateToken.getToken()).getType() != Token.TokenType.Variable) break;
                    String varName = token.getLexeme();
                    VariableMeta varMeta = (VariableMeta)variables.get(varName);
                    if (varMeta == null) {
                        varMeta = new VariableMeta((CompileTypes)realToken.getMeta("type"), varName, realToken.getMeta("isInitialized", false), realToken.getStartIndex());
                        variables.put(varName, varMeta);
                        break;
                    }
                    varMeta.add(realToken);
                }
            }
        }
        Expression exp = null;
        if (this.tokenList.size() <= 1) {
            if (this.tokenList.isEmpty()) {
                exp = new LiteralExpression(this.instance, null, new ArrayList<VariableMeta>(variables.values()));
            } else {
                Token<?> lastToken = this.tokenList.get(0);
                if (ExpressionParser.isLiteralToken(lastToken, this.instance)) {
                    exp = new LiteralExpression(this.instance, this.getAviatorObjectFromToken(lastToken).getValue(this.getCompileEnv()), new ArrayList<VariableMeta>(variables.values()));
                }
            }
        }
        if (exp == null) {
            this.callASM(variables, methods, constants);
            exp = this.codeGen.getResult(unboxObject);
        }
        if (exp instanceof BaseExpression) {
            ExpressionAccessor.setCompileEnv((BaseExpression)exp, this.getCompileEnv());
            ExpressionAccessor.setSourceFile((BaseExpression)exp, this.sourceFile);
        }
        return exp;
    }

    private void callASM(Map<String, VariableMeta> variables, Map<String, Integer> methods, Set<Token<?>> constants) {
        this.codeGen.initConstants(constants);
        this.codeGen.initVariables(variables);
        this.codeGen.initMethods(methods);
        this.codeGen.setLambdaBootstraps(this.lambdaBootstraps);
        this.codeGen.start();
        block47: for (int i = 0; i < this.tokenList.size(); ++i) {
            Token<?> token = this.tokenList.get(i);
            switch (token.getType()) {
                case Operator: {
                    OperatorToken op = (OperatorToken)token;
                    switch (op.getOperatorType()) {
                        case ADD: {
                            this.codeGen.onAdd(token);
                            break;
                        }
                        case SUB: {
                            this.codeGen.onSub(token);
                            break;
                        }
                        case MULT: {
                            this.codeGen.onMult(token);
                            break;
                        }
                        case Exponent: {
                            this.codeGen.onExponent(token);
                            break;
                        }
                        case DIV: {
                            this.codeGen.onDiv(token);
                            break;
                        }
                        case MOD: {
                            this.codeGen.onMod(token);
                            break;
                        }
                        case EQ: {
                            this.codeGen.onEq(token);
                            break;
                        }
                        case NEQ: {
                            this.codeGen.onNeq(token);
                            break;
                        }
                        case LT: {
                            this.codeGen.onLt(token);
                            break;
                        }
                        case LE: {
                            this.codeGen.onLe(token);
                            break;
                        }
                        case GT: {
                            this.codeGen.onGt(token);
                            break;
                        }
                        case GE: {
                            this.codeGen.onGe(token);
                            break;
                        }
                        case NOT: {
                            this.codeGen.onNot(token);
                            break;
                        }
                        case NEG: {
                            this.codeGen.onNeg(token);
                            break;
                        }
                        case AND: {
                            this.codeGen.onAndRight(token);
                            break;
                        }
                        case OR: {
                            this.codeGen.onJoinRight(token);
                            break;
                        }
                        case FUNC: {
                            this.codeGen.onMethodInvoke(token);
                            break;
                        }
                        case INDEX: {
                            this.codeGen.onArrayIndexEnd(token);
                            break;
                        }
                        case MATCH: {
                            this.codeGen.onMatch(token);
                            break;
                        }
                        case TERNARY: {
                            this.codeGen.onTernaryRight(token);
                            break;
                        }
                        case BIT_AND: {
                            this.codeGen.onBitAnd(token);
                            break;
                        }
                        case BIT_OR: {
                            this.codeGen.onBitOr(token);
                            break;
                        }
                        case BIT_XOR: {
                            this.codeGen.onBitXor(token);
                            break;
                        }
                        case BIT_NOT: {
                            this.codeGen.onBitNot(token);
                            break;
                        }
                        case SHIFT_LEFT: {
                            this.codeGen.onShiftLeft(token);
                            break;
                        }
                        case SHIFT_RIGHT: {
                            this.codeGen.onShiftRight(token);
                            break;
                        }
                        case DEFINE: {
                            this.codeGen.onAssignment(token.withMeta("define", true));
                            break;
                        }
                        case ASSIGNMENT: {
                            this.codeGen.onAssignment(token);
                            break;
                        }
                        case U_SHIFT_RIGHT: {
                            this.codeGen.onUnsignedShiftRight(token);
                        }
                    }
                    continue block47;
                }
                case Delegate: {
                    DelegateToken delegateToken = (DelegateToken)token;
                    Token<?> realToken = delegateToken.getToken();
                    switch (delegateToken.getDelegateTokenType()) {
                        case And_Left: {
                            this.codeGen.onAndLeft(realToken);
                            break;
                        }
                        case Join_Left: {
                            this.codeGen.onJoinLeft(realToken);
                            break;
                        }
                        case Array: {
                            this.codeGen.onArray(realToken);
                            break;
                        }
                        case Index_Start: {
                            this.codeGen.onArrayIndexStart(realToken);
                            break;
                        }
                        case Ternary_Boolean: {
                            this.codeGen.onTernaryBoolean(realToken);
                            break;
                        }
                        case Ternary_Left: {
                            this.codeGen.onTernaryLeft(realToken);
                            break;
                        }
                        case Method_Name: {
                            this.codeGen.onMethodName(realToken);
                            break;
                        }
                        case Method_Param: {
                            this.codeGen.onMethodParameter(realToken);
                            break;
                        }
                        case Lambda_New: {
                            this.codeGen.genNewLambdaCode(delegateToken.getLambdaFunctionBootstrap());
                            break;
                        }
                        case Ternay_End: {
                            this.codeGen.onTernaryEnd(realToken);
                        }
                    }
                    continue block47;
                }
                default: {
                    this.codeGen.onConstant(token);
                }
            }
        }
    }

    private void printTokenList() {
    }

    @Override
    public void onAdd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.ADD));
    }

    @Override
    public void onAndLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.And_Left));
    }

    @Override
    public void onAndRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.AND));
    }

    @Override
    public void onConstant(Token<?> lookhead) {
        this.tokenList.add(lookhead);
    }

    @Override
    public void onDiv(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.DIV));
    }

    @Override
    public void onArrayIndexStart(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Index_Start));
    }

    @Override
    public void onAssignment(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, lookhead == null || lookhead.getMeta("define", false) == false ? OperatorType.ASSIGNMENT : OperatorType.DEFINE));
    }

    @Override
    public void onArrayIndexEnd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.INDEX));
    }

    @Override
    public void onArray(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Array));
    }

    @Override
    public void onEq(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.EQ));
    }

    @Override
    public void onGe(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.GE));
    }

    @Override
    public void onGt(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.GT));
    }

    @Override
    public void onJoinLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Join_Left));
    }

    @Override
    public void onJoinRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.OR));
    }

    @Override
    public void onLe(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.LE));
    }

    @Override
    public void onLt(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.LT));
    }

    @Override
    public void onMatch(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.MATCH));
    }

    @Override
    public void onMethodInvoke(Token<?> lookhead) {
        OperatorToken token = new OperatorToken(lookhead, OperatorType.FUNC);
        token.setMetaMap(lookhead != null ? lookhead.getMetaMap() : null);
        this.tokenList.add(token);
    }

    @Override
    public void onMethodName(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Method_Name));
    }

    @Override
    public void onMethodParameter(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Method_Param));
    }

    @Override
    public void onLambdaDefineStart(Token<?> lookhead) {
        if (this.lambdaGenerator != null) {
            throw new CompileExpressionErrorException("Compile lambda error");
        }
        Boolean newLexicalScope = lookhead.getMeta("newLexicalScope", false);
        Boolean inheritEnv = lookhead.getMeta("inheritEnv", false);
        this.lambdaGenerator = new LambdaGenerator(this.instance, this, this.parser, this.codeGen.getClassLoader(), this.sourceFile, newLexicalScope, inheritEnv);
        this.lambdaGenerator.setScopeInfo(this.parser.enterScope(newLexicalScope));
    }

    @Override
    public void onLambdaArgument(Token<?> lookhead, FunctionParam param) {
        this.lambdaGenerator.addParam(param);
    }

    @Override
    public void onLambdaBodyStart(Token<?> lookhead) {
        this.parentCodeGenerator = this.parser.getCodeGenerator();
        this.parser.setCodeGenerator(this.lambdaGenerator);
    }

    @Override
    public void onLambdaBodyEnd(Token<?> lookhead) {
        LambdaFunctionBootstrap bootstrap = this.lambdaGenerator.getLmabdaBootstrap();
        if (this.lambdaBootstraps == null) {
            this.lambdaBootstraps = new HashMap<String, LambdaFunctionBootstrap>();
        }
        this.lambdaBootstraps.put(bootstrap.getName(), bootstrap);
        DelegateToken token = new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Lambda_New);
        token.setLambdaFunctionBootstrap(bootstrap);
        this.tokenList.add(token);
        this.parser.restoreScope(this.lambdaGenerator.getScopeInfo());
        this.lambdaGenerator = null;
        this.parser.setCodeGenerator(this.parentCodeGenerator);
    }

    @Override
    public void onMod(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.MOD));
    }

    @Override
    public void onMult(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.MULT));
    }

    @Override
    public void onExponent(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.Exponent));
    }

    @Override
    public void onNeg(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.NEG));
    }

    @Override
    public void onNeq(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.NEQ));
    }

    @Override
    public void onNot(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.NOT));
    }

    @Override
    public void onSub(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.SUB));
    }

    @Override
    public void onTernaryBoolean(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Ternary_Boolean));
    }

    @Override
    public void onTernaryLeft(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Ternary_Left));
    }

    @Override
    public void onTernaryRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.TERNARY));
    }

    @Override
    public void onTernaryEnd(Token<?> lookhead) {
        this.tokenList.add(new DelegateToken(lookhead, DelegateToken.DelegateTokenType.Ternay_End));
    }

    @Override
    public void onBitAnd(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.BIT_AND));
    }

    @Override
    public void onBitNot(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.BIT_NOT));
    }

    @Override
    public void onBitOr(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.BIT_OR));
    }

    @Override
    public void onShiftLeft(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.SHIFT_LEFT));
    }

    @Override
    public void onShiftRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.SHIFT_RIGHT));
    }

    @Override
    public void onUnsignedShiftRight(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.U_SHIFT_RIGHT));
    }

    @Override
    public void onBitXor(Token<?> lookhead) {
        this.tokenList.add(new OperatorToken(lookhead, OperatorType.BIT_XOR));
    }
}

