/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.runtime.JavaMethodReflectionFunctionMissing;
import com.googlecode.aviator.utils.Env;
import java.io.IOException;
import java.util.Map;

public class Main {
    public static void main(String[] args2) throws Exception {
        if (args2 == null || args2.length < 1) {
            System.err.println("Usage: java com.googlecode.aviator.Main [file] [args]");
            System.err.println("     : java com.googlecode.aviator.Main -e [script]");
            System.err.println("     : java com.googlecode.aviator.Main -v");
            System.exit(1);
        }
        AviatorEvaluator.getInstance().setOption(Options.FEATURE_SET, Feature.getFullFeatures());
        AviatorEvaluator.getInstance().setFunctionMissing(JavaMethodReflectionFunctionMissing.getInstance());
        String cmdOrPath = args2[0];
        if (cmdOrPath.equals("-v") || cmdOrPath.equals("--version")) {
            System.out.println("AviatorScript " + AviatorEvaluator.VERSION);
            System.exit(0);
        } else if (cmdOrPath.equals("-e") || cmdOrPath.equals("--execute")) {
            if (args2.length < 2) {
                System.err.println("Usage: java com.googlecode.aviator.Main -e [script]");
                System.exit(1);
            }
            String script = args2[1];
            String[] remainArgs = Main.getRemainArgs(args2, 2);
            Expression exp = AviatorEvaluator.getInstance().compile(script);
            System.out.println(exp.execute(Main.newEnv(exp, null, remainArgs)));
        } else {
            String[] remainArgs = Main.getRemainArgs(args2, 1);
            Expression exp = AviatorEvaluator.getInstance().compileScript(cmdOrPath);
            System.out.println(exp.execute(Main.newEnv(exp, cmdOrPath, remainArgs)));
        }
    }

    private static Map<String, Object> newEnv(Expression exp, String abPath, String[] args2) throws IOException {
        Env exports = new Env();
        Map<String, Object> module = exp.newEnv("exports", exports, "path", abPath, "dir", Main.getFileDir(abPath));
        Map<String, Object> env = exp.newEnv("__MODULE__", module, "exports", exports, "ARGV", args2);
        return env;
    }

    private static String getFileDir(String abPath) throws IOException {
        return abPath != null ? AviatorEvaluator.getInstance().tryFindScriptFile(abPath).getAbsoluteFile().getParent() : null;
    }

    private static String[] getRemainArgs(String[] args2, int startPos) {
        String[] remainArgs = new String[args2.length - startPos];
        System.arraycopy(args2, startPos, remainArgs, 0, remainArgs.length);
        return remainArgs;
    }
}

