/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.EnvProcessor;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Options;
import com.googlecode.aviator.exception.ExpressionNotFoundException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.CompileTypes;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.FunctionArgument;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.function.LambdaFunction;
import com.googlecode.aviator.utils.Constants;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import com.googlecode.aviator.utils.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public abstract class BaseExpression
implements Expression {
    private static final long serialVersionUID = 2819544277750883372L;
    public static final String FUNC_PARAMS_VAR = "__funcs_args__";
    protected transient List<String> varNames;
    protected transient List<String> varFullNames;
    private List<VariableMeta> vars;
    private String expression;
    protected transient AviatorEvaluatorInstance instance;
    private Env compileEnv;
    private Map<Integer, List<FunctionArgument>> funcsArgs = Collections.emptyMap();
    protected SymbolTable symbolTable;
    private transient ConcurrentHashMap<String, FutureTask<AviatorEvaluatorInstance.StringSegments>> stringSegs = new ConcurrentHashMap();
    private List<String> functionNames = Collections.emptyList();
    private transient List<String> filteredFunctionNames = null;
    protected String sourceFile;
    protected Map<String, LambdaFunctionBootstrap> lambdaBootstraps;

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    protected void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    protected void setInstance(AviatorEvaluatorInstance instance) {
        this.instance = instance;
    }

    public BaseExpression(AviatorEvaluatorInstance instance, List<VariableMeta> vars, SymbolTable symbolTable) {
        this.vars = vars;
        this.symbolTable = symbolTable;
        this.instance = instance;
    }

    private void populateNames() {
        if (this.varNames == null) {
            if (this.varFullNames == null) {
                this.populateFullNames();
            }
            ArrayList<String> newVarNames = new ArrayList<String>(this.varFullNames.size());
            HashSet<String> nameSet = new HashSet<String>();
            HashSet<String> parentInitNames = new HashSet<String>();
            for (VariableMeta m : this.vars) {
                if (!m.isInit() || m.getName().contains(".") || m.getFirstIndex() < 0) continue;
                parentInitNames.add(m.getName());
            }
            for (String fName : this.varFullNames) {
                String[] tmps = Constants.SPLIT_PAT.split(fName);
                String sName = tmps[0];
                if (nameSet.contains(sName) || parentInitNames.contains(sName)) continue;
                newVarNames.add(sName);
                nameSet.add(sName);
            }
            this.varNames = newVarNames;
        }
    }

    protected void afterPopulateFullNames(Map<String, VariableMeta> fullNames, Set<String> parentVars) {
        if (this.lambdaBootstraps != null && !this.lambdaBootstraps.isEmpty()) {
            for (LambdaFunctionBootstrap bootstrap : this.lambdaBootstraps.values()) {
                for (VariableMeta meta : bootstrap.getClosureOverFullVarNames()) {
                    String name = meta.getName();
                    VariableMeta existsMeta = fullNames.get(name);
                    if (existsMeta == null) {
                        String[] tmps = Constants.SPLIT_PAT.split(name);
                        if (parentVars.contains(tmps[0])) continue;
                        fullNames.put(meta.getName(), meta);
                        continue;
                    }
                    if (existsMeta.getFirstIndex() <= meta.getFirstIndex()) continue;
                    fullNames.put(meta.getName(), meta);
                }
            }
        }
    }

    private void populateFullNames() {
        if (this.varFullNames == null) {
            Map<String, VariableMeta> fullNames = this.getFullNameMetas();
            ArrayList<VariableMeta> metas = new ArrayList<VariableMeta>(fullNames.values());
            Collections.sort(metas, new Comparator<VariableMeta>(){

                @Override
                public int compare(VariableMeta o1, VariableMeta o2) {
                    return Integer.compare(o1.getFirstIndex(), o2.getFirstIndex());
                }
            });
            ArrayList<String> newFullNames = new ArrayList<String>(fullNames.size());
            for (VariableMeta meta : metas) {
                newFullNames.add(meta.getName());
            }
            this.varFullNames = newFullNames;
        }
    }

    public Map<String, VariableMeta> getFullNameMetas() {
        LinkedHashMap<String, VariableMeta> fullNames = new LinkedHashMap<String, VariableMeta>(this.vars.size());
        HashSet<String> parentVars = new HashSet<String>(this.vars.size());
        HashSet<String> definedVars = new HashSet<String>();
        for (VariableMeta m : this.vars) {
            String name = m.getName();
            String[] tmps = Constants.SPLIT_PAT.split(name);
            if (!(m.isInit() || m.getType() == CompileTypes.Class || definedVars.contains(tmps[0]) || definedVars.contains(name) || m.getFirstIndex() < 0)) {
                fullNames.put(name, m);
            } else if (m.getFirstIndex() >= 0) {
                definedVars.add(name);
                definedVars.add(tmps[0]);
            }
            parentVars.add(name);
        }
        this.afterPopulateFullNames(fullNames, parentVars);
        return fullNames;
    }

    public AviatorEvaluatorInstance.StringSegments getStringSegements(final String lexeme, final int lineNo) {
        FutureTask<AviatorEvaluatorInstance.StringSegments> task = this.stringSegs.get(lexeme);
        if (task == null) {
            task = new FutureTask<AviatorEvaluatorInstance.StringSegments>(new Callable<AviatorEvaluatorInstance.StringSegments>(){

                @Override
                public AviatorEvaluatorInstance.StringSegments call() throws Exception {
                    AviatorEvaluatorInstance.StringSegments compiledSegs = BaseExpression.this.instance.compileStringSegments(lexeme, BaseExpression.this.sourceFile, lineNo);
                    return compiledSegs;
                }
            });
            FutureTask<AviatorEvaluatorInstance.StringSegments> existsTask = this.stringSegs.putIfAbsent(lexeme, task);
            if (existsTask != null) {
                task = existsTask;
            } else {
                task.run();
            }
        }
        try {
            return task.get();
        }
        catch (ExecutionException t) {
            throw Reflector.sneakyThrow(t.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Reflector.sneakyThrow(e);
        }
    }

    @Override
    public Map<String, Object> newEnv(Object ... args2) {
        if (args2 != null && args2.length % 2 != 0) {
            throw new IllegalArgumentException("Expect arguments number is even.");
        }
        SymbolHashMap env = new SymbolHashMap(args2 != null ? args2.length : 10);
        if (args2 != null) {
            for (int i = 0; i < args2.length; i += 2) {
                String key = (String)args2[i];
                env.put(key, args2[i + 1]);
            }
        }
        return env;
    }

    public abstract Object executeDirectly(Map<String, Object> var1);

    @Override
    public Object execute(Map<String, Object> map) {
        return this.execute(map, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Map<String, Object> map, boolean checkExecutionTimeout) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        Env env = this.genTopEnv(map, checkExecutionTimeout);
        EnvProcessor envProcessor = this.instance.getEnvProcessor();
        if (envProcessor != null) {
            envProcessor.beforeExecute(env, this);
        }
        try {
            Object object = this.executeDirectly(env);
            return object;
        }
        finally {
            if (envProcessor != null) {
                envProcessor.afterExecute(env, this);
            }
        }
    }

    protected void setFuncsArgs(Map<Integer, List<FunctionArgument>> funcsArgs) {
        if (funcsArgs != null) {
            this.funcsArgs = Collections.unmodifiableMap(funcsArgs);
        }
    }

    public Env getCompileEnv() {
        return this.compileEnv;
    }

    protected void setCompileEnv(Env compileEnv) {
        this.compileEnv = compileEnv;
        this.compileEnv.setExpression(this);
    }

    public String getExpression() {
        return this.expression;
    }

    protected void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public String addSymbol(String name) {
        if (this.symbolTable != null) {
            return this.symbolTable.reserve(name).getLexeme();
        }
        return name;
    }

    @Override
    public Object execute() {
        return this.execute(null);
    }

    @Override
    public List<String> getVariableFullNames() {
        this.populateFullNames();
        return this.varFullNames;
    }

    public List<VariableMeta> getVars() {
        return this.vars;
    }

    @Override
    public List<String> getVariableNames() {
        this.populateNames();
        return this.varNames;
    }

    protected Env newEnv(Map<String, Object> map, boolean direct, boolean checkExecutionTimeout) {
        Env env = direct ? new Env(map, map == Collections.EMPTY_MAP ? new HashMap() : map) : new Env(map);
        env.configure(this.instance, this, this.getExecutionStartNs(checkExecutionTimeout), null);
        return env;
    }

    protected Env genTopEnv(Map<String, Object> map, boolean checkExecutionTimeout) {
        if (map instanceof Env) {
            ((Env)map).configure(this.instance, this, this.getExecutionStartNs(checkExecutionTimeout), null);
        }
        Env env = this.newEnv(map, this.instance.getOptionValue((Options)Options.USE_USER_ENV_AS_TOP_ENV_DIRECTLY).bool, checkExecutionTimeout);
        if (this.compileEnv != null && !this.compileEnv.isEmpty()) {
            env.putAll((Map)this.compileEnv);
        }
        if (!this.funcsArgs.isEmpty()) {
            env.override(FUNC_PARAMS_VAR, this.funcsArgs);
        }
        return env;
    }

    private long getExecutionStartNs(boolean checkExecutionTimeout) {
        long startNs = -1L;
        if (checkExecutionTimeout && this.instance.getOptionValue((Options)Options.EVAL_TIMEOUT_MS).number > 0) {
            startNs = Utils.currentTimeNanos();
        }
        return startNs;
    }

    protected Env newEnv(Map<String, Object> map) {
        return this.newEnv(map, false, true);
    }

    @Override
    public List<String> getFunctionNames() {
        this.populateFilteredFuncNames();
        return this.filteredFunctionNames;
    }

    private void populateFilteredFuncNames() {
        if (this.filteredFunctionNames == null) {
            HashSet<String> validNames = new HashSet<String>(this.functionNames.size());
            for (String funcName : this.functionNames) {
                if (funcName.startsWith("__") || funcName.equals("with_meta")) continue;
                validNames.add(funcName);
            }
            HashSet<String> definedFuncs = new HashSet<String>();
            for (VariableMeta v : this.vars) {
                if (!v.isInit()) continue;
                definedFuncs.add(v.getName());
            }
            if (this.lambdaBootstraps != null) {
                for (LambdaFunctionBootstrap bootstrap : this.lambdaBootstraps.values()) {
                    validNames.addAll(bootstrap.getExpression().getFunctionNames());
                }
            }
            validNames.removeAll(definedFuncs);
            this.filteredFunctionNames = new ArrayList<String>(validNames);
        }
    }

    protected void setFunctionNames(List<String> functionNames) {
        if (functionNames != null) {
            this.functionNames = functionNames;
        }
    }

    public Map<String, LambdaFunctionBootstrap> getLambdaBootstraps() {
        return this.lambdaBootstraps;
    }

    protected void setLambdaBootstraps(Map<String, LambdaFunctionBootstrap> lambdaBootstraps) {
        this.lambdaBootstraps = lambdaBootstraps;
    }

    public LambdaFunction newLambda(Env env, String name) {
        LambdaFunctionBootstrap bootstrap = this.lambdaBootstraps.get(name);
        if (bootstrap == null) {
            throw new ExpressionNotFoundException("Lambda " + name + " not found");
        }
        return bootstrap.newInstance(env);
    }

    public void customReadObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        this.vars = (List)input.readObject();
        this.expression = (String)input.readObject();
        this.compileEnv = (Env)input.readObject();
        this.funcsArgs = (Map)input.readObject();
        this.symbolTable = (SymbolTable)input.readObject();
        this.sourceFile = (String)input.readObject();
        this.lambdaBootstraps = (Map)input.readObject();
        this.stringSegs = new ConcurrentHashMap();
        this.functionNames = (List)input.readObject();
    }

    public void customWriteObject(ObjectOutputStream output) throws IOException {
        output.writeObject(this.vars);
        output.writeObject(this.expression);
        output.writeObject(this.compileEnv);
        output.writeObject(this.funcsArgs);
        output.writeObject(this.symbolTable);
        output.writeObject(this.sourceFile);
        output.writeObject(this.lambdaBootstraps);
        output.writeObject(this.functionNames);
    }

    private class SymbolHashMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 5951510458689965590L;

        public SymbolHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public Object put(String key, Object value) {
            Variable var = null;
            if (BaseExpression.this.symbolTable != null && (var = BaseExpression.this.symbolTable.getVariable(key)) != null) {
                key = var.getLexeme();
            }
            return super.put(key, value);
        }
    }
}

